% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umbrella.R
\name{umbrella}
\alias{umbrella}
\title{Conduct the calculations for an umbrella review}
\usage{
umbrella(
  x,
  method.var = "REML",
  mult.level = FALSE,
  r = 0.5,
  true_effect = "largest",
  seed = NA,
  verbose = TRUE
)
}
\arguments{
\item{x}{a well-formatted dataset.}

\item{method.var}{the estimator used to quantify the between-study variance in the random-effects meta-analysis. Default is the Restricted Likelihood Maximum ("REML") estimator. Alternatively, Der-Simonian and Laird \code{"DL"}, Hartung-Knapp-Sidik-Jonkman \code{"hksj"}, maximum-likelihood \code{"ML"} or Paule-Mandel \code{"PM"} estimators can be used.}

\item{mult.level}{a logical variable indicating the presence of multiple effect sizes per study in at least one factor of the umbrella review. Default is \code{FALSE} (i.e., each study of all factors include only one effect size). If \code{mult.level = TRUE} is specified, the Borenstein's methods are used to generate only one effect size per study. See \code{\link{metaumbrella-package}} for more information.}

\item{r}{a correlation coefficient indicating the strength of the association between multiple outcomes (or time-points) within the same study. The \code{r} value is applied to all studies with multiple outcomes that have no indication of correlation in the well-formatted dataset. Default is 0.5.}

\item{true_effect}{the method to estimate the true effect in the test for excess of significance. It must be \code{"largest"}, \code{"pooled"} or a numeric value (see details). Default is "largest".}

\item{seed}{an integer value used as an argument by the set.seed() function. Only used for the Ioannidis' test for excess of significance with ratios (i.e., \dQuote{OR}, \dQuote{RR},\dQuote{HR},\dQuote{IRR} or their logarithm) as effect size measures.}

\item{verbose}{a logical variable indicating whether text outputs and messages should be generated. We recommend turning this option to FALSE only after having carefully read all the generated messages.}
}
\value{
The \code{umbrella()} function returns an object of class \dQuote{umbrella}, which is a list containing information required for stratifying the evidence.
This list contains, for each factor included in the umbrella review:
\tabular{ll}{
\code{measure} \tab the measure of the effect used to perform the calculations: SMD, OR,\cr
\tab RR, HR, or IRR.\cr
\tab \cr
\code{x} \tab the data used to conduct the meta-analysis. Note that these data may be\cr
\tab slightly different from the raw data introduced.\cr
\tab \cr
\code{x_multi} \tab the original data when there is a multivariate structure.\cr
\tab Note that these data may be slightly different from the raw data introduced.\cr
\tab \cr
\code{x_shared} \tab dataframe allowing to compare adjustments made when a shared_nexp\cr
\tab or shared_controls correction is requested\cr
\tab (see \code{\link{metaumbrella-package}} for more information).\cr
\tab \cr
\code{n} \tab the overall number of studies, cases and controls.\cr
\tab \cr
\code{method.var} \tab the estimator used for fitting the random effects meta-analyses\cr
\tab \cr
\code{random} \tab pooled effect size, p-value and 95\% confidence interval and prediction\cr
\tab  interval of the random-effects meta-analysis.\cr
\tab \cr
\code{fixed} \tab pooled effect size, p-value and 95\% confidence interval and prediction\cr
\tab  interval of the fixed-effect meta-analysis.\cr
\tab \cr
\code{largest} \tab 95\% confidence interval of the largest study.\cr
\tab \cr
\code{heterogeneity} \tab \eqn{tau^2}, \eqn{I^2} and Q test.\cr
\tab \cr
\code{egger} \tab estimate and p-value of the Egger's test for publication bias.\cr
\tab \cr
\code{esb} \tab results of the Ioannidis' test for excess of significance bias. See\cr
\tab \code{\link{esb.test}()} for more information.\cr
\tab \cr
\code{riskofbias} \tab percentage of participants in studies at low risk of bias.\cr
\tab \cr
\code{amstar} \tab AMSTAR score obtained by the meta-analysis.\cr
\tab \cr
\code{evidence} \tab evidence class according to some criteria.\cr
\tab \cr
}
The functions \code{print} and \code{summary} may be used to print the details or a summary of the results.
}
\description{
This function performs various calculations needed for an umbrella review.
}
\details{
This function automatically performs calculations allowing to stratify evidence according to various criteria.
More precisely, this function :
\itemize{
\item performs fixed- and random-effects meta-analyses with or without a Hartung-Knapp-Sidik-Jonkman correction.
\item provides an estimation of the between-study variance and heterogeneity using three indicators (\eqn{tau^2}, Q-statistic and \eqn{I^2} statistic).
\item estimates the 95\% prediction interval (if the number of studies is equal or larger to 3).
\item provides an identification of the statistical significance of the largest study included in the meta-analysis.
\item provides an assessment of publication bias using the Egger's test (if the number of studies is equal or larger to 3).
\item provides an assessment of excess significance bias using the Ioannidis' test.
\item performs a jackknife leave-one-out meta-analysis(if the number of studies is equal or larger to 2).
\item calculates the proportion of participants included in studies at low risk of bias (if study quality is indicated in the dataset).
}

A specificity of this function is that it does not include arguments to specify the name of the columns of the dataset used as input.
Instead, the function requires users to build a dataset that meets fixed rules.
Details on how building this \code{well-formatted dataset} are given in the \code{\link{metaumbrella-package}} section of this manual and a vignette is specifically dedicated to this topic.
Moreover, examples of \code{well-formatted datasets} are available as data distributed along with the package (see \link{df.OR}, \link{df.OR.multi}, \link{df.SMD}, \link{df.RR}, \link{df.HR}, \link{df.IRR}).

When estimating the test for excess of significance, the \code{\link{umbrella}()} function should assume a value for the true effeect. The \code{true_effect} argument can be used to select the method that will be applied to estimate the true effect.
\itemize{
\item If \code{"largest"} is selected, the true effect size is assumed to be equal to the effect size of the largest study included in the meta-analysis.
\item If \code{"pooled"} is selected, the true effect size is assumed to be equal to the pooled effect of the meta-analysis.
\item If a \code{numeric} value is entered, the true effect size is assumed to be equal to the value entered by the user.
}
}
\examples{
\donttest{
### Perform an umbrella review with random-effects meta-analyses
### with a Hartung-Knapp-Sidik-Jonkman estimator
umb <- umbrella(df.IRR, method.var = "hksj")

### obtain the results of the calculations in a dataframe
summary(umb)

### manually inspect the results of the umbrella review calculations for the 'Smoking' factor
### included in the dataset.
umb$Smoking

### Perform a meta-analysis with multilevel data, assuming a correlation of 0.8
### between all outcomes of the same study
umb.multi <- umbrella(df.OR.multi, mult.level = TRUE, r = 0.8)

### the stratification of evidence can then normally be applied on this umbrella object
add.evidence(umb.multi, criteria = "Ioannidis")
}
}
\references{
Fusar-Poli, P., Radua, J. (2018).  Ten simple rules for conducting umbrella reviews.
\emph{Evidence-Based Mental Health}, \bold{21}, 95--100.\cr
Radua, J., Ramella-Cravaro, V., Ioannidis, J.P.A., Reichenberg, A., Phiphopthatsanee, N., Amir, T., Yenn Thoo, H., Oliver, D., Davies, C., Morgan, C., McGuire, P., Murray, R.M., Fusar-Poli, P. (2018)
What causes psychosis? An umbrella review of risk and protective factors.
\emph{World Psychiatry}, \bold{17}, 49--66.
}
\seealso{
\code{\link{metaumbrella-package}} for the formatting of well-formatted datasets.
\code{\link{add.evidence}()} for adding evidence classes to an umbrella review.
\code{\link{forest}()} for drawing a forest plot of the factors included in an umbrella review.
\code{\link{subset.umbrella}()} for retrieving a subset of the factors included in an umbrella review.
\code{\link{union.umbrella}()} for combining the factors included in two umbrella reviews.
}
