% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umbrella_GUI.R
\name{umbrella.gui}
\alias{umbrella.gui}
\title{Graphical User Interface for conducting an umbrella review}
\usage{
umbrella.gui()
}
\value{
The \code{umbrella.gui()} function returns several elements including \tabular{ll}{
\code{csv} \tab a csv file containing the results of the umbrella review.\cr
\tab \cr
\code{pdf} \tab a pdf file containing the plot of the results (only if requested, i.e., the \code{plot_results}\cr
\tab argument is set as TRUE).\cr
\tab \cr
\code{html} \tab an HTML file containing the results of the umbrella review.\cr
}
}
\description{
The \code{umbrella.gui} function allows to perform an umbrella review in R with a graphical user interface.
}
\details{
After entering \code{umbrella.gui()} in the R console, a window will open.
\itemize{
\item The first step is to load your dataset by clicking on the button at the right of the "Excel file" label. An explorator window will open, allowing you to select the file you want to upload.
\item The second step is to select the folder where the results will be exported. Again, click on the button at the right of the "Output folder" label, and select the appropriate folder thanks to the explorator window.
\item Last, select the criteria you want to use for stratifying evidence. For now, "Ioannidis" and "GRADE" criteria are available.
}
}
\examples{
if(interactive()){
### open the GUI
umbrella.gui()
}
}
\seealso{
See \code{\link{umbrella}()}, \code{\link{add.evidence}()}, and \code{\link{summary.umbrella}()} for more information.
}
