% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_mpm.R
\name{random_mpm}
\alias{random_mpm}
\title{Generate random Lefkovitch matrix population models (MPMs) based on life
history archetypes}
\usage{
random_mpm(n_stages, fecundity, archetype = 1, split = FALSE)
}
\arguments{
\item{n_stages}{An integer defining the number of stages for the MPM.}

\item{fecundity}{Mean fecundity. This value is the lambda value for a Poisson
distribution from which a value for fecundity is drawn. An integer of
length 1 or a vector of integers of length equal to the number of stages.
If there is no reproduction in a particular age class, use a value of 0.}

\item{archetype}{Indication of which life history archetype should be used,
based on Takada et al. 2018. An integer between 1 and 4.}

\item{split}{TRUE/FALSE, indicating whether the matrix produced should be
split into a survival matrix and a fertility matrix. Yeah true, then the
output becomes a list with a matrix in each element. Otherwise, the output
is a single matrix.}
}
\value{
Returns a random matrix population model with characteristics
determined by the archetype selected and fecundity vector. If split = TRUE,
the matrix is split into separate fertility and a growth/survival matrices,
returned as a list.
}
\description{
Generates a random matrix population model (MPM) with element values based on
defined life history archetypes. Survival and transition/growth probabilities
from any particular stage are restricted to be less than or equal to 1 by
drawing from a Dirichlet distribution. The user can specify archetypes (from
Takada et al. 2018) to restrict the MPMs in other ways:
\itemize{
\item Archetype 1: all elements are positive, although they may be very small.
Therefore, transition from/to any stage is possible. This model describes a
life history where individuals can progress and retrogress rapidly.
\item Archetype 2: has the same form as archetype 1 (transition from/to any stage
is possible), but the survival probability (column sums of the survival
matrix) increases monotonously as the individuals advance to later stages.
This model, as the one in the first archetype, also allows for rapid
progression and retrogression, but is more realistic in that stage-specific
survival probability increases with stage advancement.
\item Archetype 3: positive non-zero elements for survival are only allowed on
the diagonal and lower sub-diagonal of the matrix This model represents the
life cycle of a species where retrogression is not allowed, and progression
can only happen to the immediately larger/more developed stage (slow
progression, e.g., trees).
\item Archetype 4: This archetype has the same general form as archetype 3, but
with the further assumption that stage-specific survival increases as
individuals increase in size/developmental stage. In this respect it is
similar to archetype 2.
}
}
\details{
In all 4 of these Archetypes, fecundity is placed as a single element on the
top right of the matrix, if it is a single value. If it is a vector of length
\code{n_stages} then the fertility vector spans the entire top row of the matrix.

The function is constrained to only output ergodic matrices.
}
\examples{
random_mpm(n_stages = 2, fecundity = 20, archetype = 1, split = FALSE)
random_mpm(n_stages = 2, fecundity = 20, archetype = 2, split = TRUE)
random_mpm(n_stages = 3, fecundity = 20, archetype = 3, split = FALSE)
random_mpm(n_stages = 4, fecundity = 20, archetype = 4, split = TRUE)
random_mpm(
  n_stages = 5, fecundity = c(0, 0, 4, 8, 10), archetype = 4,
  split = TRUE
)
}
\references{
Caswell, H. (2001). Matrix Population Models: Construction, Analysis, and
Interpretation. Sinauer.

Lefkovitch, L. P. (1965). The study of population growth in organisms grouped
by stages. Biometrics, 21(1), 1.

Takada, T., Kawai, Y., & Salguero-Gómez, R. (2018). A cautionary note on
elasticity analyses in a ternary plot using randomly generated population
matrices. Population Ecology, 60(1), 37–47.
}
\seealso{
\code{\link[=generate_mpm_set]{generate_mpm_set()}} which is a wrapper for this function allowing
the generation of large numbers of random matrices of this type.

Other simulation: 
\code{\link{generate_mpm_set}()}
}
\author{
Owen Jones \href{mailto:jones@biology.sdu.dk}{jones@biology.sdu.dk}
}
\concept{simulation}
