% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/pca.R
\docType{methods}
\name{pca_coda}
\alias{pca_coda}
\alias{pca,CompositionMatrix-method}
\alias{pca,LogRatio-method}
\title{Principal Components Analysis}
\usage{
\S4method{pca}{CompositionMatrix}(
  object,
  center = TRUE,
  scale = FALSE,
  rank = NULL,
  sup_row = NULL,
  sup_col = NULL,
  weight_row = NULL,
  weight_col = NULL
)

\S4method{pca}{LogRatio}(
  object,
  center = TRUE,
  scale = FALSE,
  rank = NULL,
  sup_row = NULL,
  sup_col = NULL,
  weight_row = NULL,
  weight_col = NULL
)
}
\arguments{
\item{object}{A \code{\linkS4class{LogRatio}} object.}

\item{center}{A \code{\link{logical}} scalar: should the variables be shifted to be
zero centered?}

\item{scale}{A \code{\link{logical}} scalar: should the variables be scaled to unit
variance?}

\item{rank}{An \code{\link{integer}} value specifying the maximal number of components
to be kept in the results. If \code{NULL} (the default), \eqn{p - 1} components
will be returned.}

\item{sup_row}{A \code{vector} specifying the indices of the supplementary rows.}

\item{sup_col}{A \code{vector} specifying the indices of the supplementary columns.}

\item{weight_row}{A \code{\link{numeric}} vector specifying the active row (individual)
weights. If \code{NULL} (the default), uniform weights are used. Row weights are
internally normalized to sum 1}

\item{weight_col}{A \code{\link{numeric}} vector specifying the active column
(variable) weights. If \code{NULL} (the default), uniform weights (1) are
used.}
}
\value{
A \code{\link[dimensio:PCA-class]{dimensio::PCA}} object. See package \pkg{dimensio} for details.
}
\description{
Computes a principal components analysis based on the singular value
decomposition.
}
\examples{
## Data from Day et al. 2011
data("kommos", package = "folio") # Coerce to compositional data
kommos <- remove_NA(kommos, margin = 1) # Remove cases with missing values
coda <- as_composition(kommos, groups = 1) # Use ceramic types for grouping

## Centered log-ratio
clr <- transform_clr(coda)

## PCA
X <- pca(clr, scale = FALSE)

## Explore results
library(dimensio)

## Plot
viz_individuals(X, highlight = get_groups(coda), pch = 16)
viz_variables(X)
}
\references{
Aitchison, J. and Greenacre, M. (2002). Biplots of compositional data.
\emph{Journal of the Royal Statistical Society: Series C (Applied Statistics)},
51: 375-392. \doi{10.1111/1467-9876.00275}.

Filzmoser, P., Hron, K. and Reimann, C. (2009). Principal component analysis
for compositional data with outliers. \emph{Environmetrics}, 20: 621-632.
\doi{10.1002/env.966}.
}
\seealso{
\code{\link[dimensio:pca]{dimensio::pca()}}, \code{\link[dimensio:biplot]{dimensio::biplot()}}, \code{\link[dimensio:screeplot]{dimensio::screeplot()}},
\code{\link[dimensio:viz_individuals]{dimensio::viz_individuals()}}, \code{\link[dimensio:viz_variables]{dimensio::viz_variables()}}
}
\author{
N. Frerebeau
}
\concept{multivariate analysis}
