% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/outliers.R
\docType{methods}
\name{plot_outliers}
\alias{plot_outliers}
\alias{plot,OutlierIndex,missing-method}
\title{Plot Outliers}
\usage{
\S4method{plot}{OutlierIndex,missing}(
  x,
  ...,
  qq = FALSE,
  probs = c(0.25, 0.75),
  ncol = NULL,
  flip = FALSE,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes,
  panel.first = NULL,
  panel.last = NULL
)
}
\arguments{
\item{x}{An \code{\linkS4class{OutlierIndex}} object.}

\item{...}{Further \link[graphics:par]{graphical parameters}.}

\item{qq}{A \code{\link{logical}} scalar: should a quantile-quantile plot be produced?}

\item{probs}{A length-two \code{\link{numeric}} vector representing probabilities.
Corresponding quantile pairs define the line drawn (see \code{\link[stats:qqnorm]{stats::qqline()}}).
Only used if \code{qq} is \code{TRUE}.}

\item{ncol}{An \code{\link{integer}} specifying the number of columns to use when
\code{facet} is "\code{multiple}". Defaults to 1 for up to 4 series, otherwise to 2.}

\item{flip}{A \code{\link{logical}} scalar: should the y-axis (ticks and numbering) be
flipped from side 2 (left) to 4 (right) from group to group?}

\item{xlab, ylab}{A \code{\link{character}} vector giving the x and y axis labels.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x
and y axis labels) appear on the plot?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}

\item{panel.first}{An an \code{expression} to be evaluated after the plot axes are
set up but before any plotting takes place. This can be useful for drawing
background grids.}

\item{panel.last}{An \code{expression} to be evaluated after plotting has taken
place but before the axes, title and box are added.}
}
\value{
\code{plot()} is called for its side-effects: is results in a graphic being
displayed (invisibly return \code{x}).
}
\description{
Plot Outliers
}
\examples{
## Data from Day et al. 2011
data("kommos", package = "folio") # Coerce to compositional data
kommos <- remove_NA(kommos, margin = 1) # Remove cases with missing values
coda <- as_composition(kommos, groups = 1) # Use ceramic types for grouping

## Detect outliers
out <- outliers(coda, groups = NULL, robust = FALSE)

plot(out) # Plot
plot(out, qq = TRUE) # Quantile-Quantile plot

## Detect outliers by group
out <- outliers(coda[, 1:15, drop = FALSE])

plot(out, ncol = 2) # Plot
plot(out, qq = TRUE, ncol = 4) # Quantile-Quantile plot
}
\references{
Filzmoser, P., Garrett, R. G. & Reimann, C. (2005). Multivariate outlier
detection in exploration geochemistry. \emph{Computers & Geosciences},
31(5), 579-587. \doi{10.1016/j.cageo.2004.11.013}.

Filzmoser, P. & Hron, K. (2008). Outlier Detection for Compositional Data
Using Robust Methods. \emph{Mathematical Geosciences}, 40(3), 233-248.
\doi{10.1007/s11004-007-9141-5}.

Filzmoser, P., Hron, K. & Reimann, C. (2012). Interpretation of multivariate
outliers for compositional data. \emph{Computers & Geosciences}, 39, 77-85.
\doi{10.1016/j.cageo.2011.06.014}.
}
\seealso{
Other outlier detection methods: 
\code{\link{outliers}()}
}
\author{
N. Frerebeau
}
\concept{outlier detection methods}
