% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Result.R
\docType{methods}
\name{dbFetch}
\alias{dbFetch}
\alias{dbFetch,AthenaResult-method}
\title{Fetch records from previously executed query}
\usage{
\S4method{dbFetch}{AthenaResult}(res, n = -1, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}, created by
\code{\link[DBI:dbSendQuery]{dbSendQuery()}}.}

\item{n}{maximum number of records to retrieve per fetch. Use \code{n = -1} or \code{n = Inf} to retrieve all pending records.
Some implementations may recognize other special values. Currently chunk sizes range from 0 to 999, 
if entire dataframe is required use \code{n = -1} or \code{n = Inf}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbFetch()} returns a data frame.
}
\description{
Currently returns the top n elements (rows) from result set or returns entire table from Athena.
}
\examples{
\donttest{
# Note: 
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `noctua::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name 
con <- dbConnect(noctua::athena())

res <- dbSendQuery(con, "show databases")
dbFetch(res)
dbClearResult(res)

# Disconnect from Athena
dbDisconnect(con)
}
}
\seealso{
\code{\link[DBI]{dbFetch}}
}
