% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assignAlleles.R
\name{assignAlleles}
\alias{assignAlleles}
\title{Assign parent alleles randomly}
\usage{
assignAlleles(alleles, parentType, parent, id, n)
}
\arguments{
\item{alleles}{a list with a list \code{alleles$alleles}, which is a list
of list containing the alleles for each individual's sire and dam that have
been assigned thus far and \code{alleles$counter} that is the counter used
to track the lists of\code{alleles$alleles}.}

\item{parentType}{character vector of length one with value of
\code{"sire"} or \code{"dam"}.}

\item{parent}{either \code{ped[id, "sire"]} or \code{ped[id, "dam"]}.}

\item{id}{character vector of length one containing the animal ID}

\item{n}{integer indicating the number of iterations to simulate.
Default is 5000.}
}
\value{
The original list \code{alleles} passed into the function with newly
randomly assigned alleles to each \code{id} based on dam and sire genotypes.
}
\description{
Assign parent alleles randomly
}
\examples{
\donttest{
alleles <- list(alleles = list(), counter = 1)
alleles <- assignAlleles(alleles, parentType = "sire", parent = NA,
                         id = "o1", n = 4)
alleles
alleles <- assignAlleles(alleles, parentType = "dam", parent = NA,
                         id = "o1", n = 4)
alleles
}

}
