% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opq.R
\name{opq_osm_id}
\alias{opq_osm_id}
\title{Add a feature specified by OSM ID to an Overpass query}
\usage{
opq_osm_id(id = NULL, type = NULL, open_url = FALSE)
}
\arguments{
\item{id}{One or more official OSM identifiers (long-form integers)}

\item{type}{Type of object; must be either \code{node}, \code{way}, or \code{relation}}

\item{open_url}{If \code{TRUE}, open the OSM page of the specified object in web
browser. Multiple objects (\code{id} values) will be opened in multiple pages.}
}
\value{
\link{opq} object
}
\description{
Add a feature specified by OSM ID to an Overpass query
}
\note{
Extracting elements by ID requires explicitly specifying the type of
element. Only elements of one of the three given types can be extracted in a
single query, but the results of multiple types can neverthelss be combined
with the \link{c} operation of \link{osmdata}.
}
\examples{
\dontrun{
id <- c (1489221200, 1489221321, 1489221491)
dat1 <- opq_osm_id (type = "node", id = id) \%>\%
    opq_string () \%>\%
    osmdata_sf ()
dat1$osm_points # the desired nodes
id <- c (136190595, 136190596)
dat2 <- opq_osm_id (type = "way", id = id) \%>\%
    opq_string () \%>\%
    osmdata_sf ()
dat2$osm_lines # the desired ways
dat <- c (dat1, dat2) # The node and way data combined
}
}
\references{
\url{https://wiki.openstreetmap.org/wiki/Overpass_API/Overpass_QL#By_element_id}
}
