% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-osmdata.R
\name{osmdata_sc}
\alias{osmdata_sc}
\title{Return an OSM Overpass query as an \link{osmdata} object in
\code{silicate} (\code{SC}) format.}
\usage{
osmdata_sc(q, doc, quiet = TRUE)
}
\arguments{
\item{q}{An object of class \code{overpass_query} constructed with
\link{opq} and \link{add_osm_feature}. May be be omitted,
in which case the \link{osmdata} object will not include the
query.}

\item{doc}{If missing, \code{doc} is obtained by issuing the overpass query,
\code{q}, otherwise either the name of a file from which to read data,
or an object of class \pkg{XML} returned from
\link{osmdata_xml}.}

\item{quiet}{suppress status messages.}
}
\value{
An object of class \code{osmdata} representing the original OSM hierarchy
of nodes, ways, and relations.
}
\description{
Return an OSM Overpass query as an \link{osmdata} object in
\code{silicate} (\code{SC}) format.
}
\note{
The \code{silicate} format is currently highly experimental, and
recommended for use only if you really know what you're doing.
}
\examples{
\dontrun{
hampi_sf <- opq ("hampi india") \%>\%
            add_osm_feature (key="historic", value="ruins") \%>\%
            osmdata_sc ()
}
}
