% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_02_users.R
\name{get_users}
\alias{get_users}
\title{Polished API - Get User(s)}
\usage{
get_users(user_uid = NULL, email = NULL, api_key = get_api_key())
}
\arguments{
\item{user_uid}{an optional user uid.}

\item{email}{an optional user email.}

\item{api_key}{your Polished API key.  Set your polished api key using \code{\link{set_api_key}()}
so that you do not need to supply this argument with each function call.}
}
\value{
an object of class \code{polished_api_res}.  The \code{content} of the object is a
tibble of users(s) with the following columns:
\itemize{
\item \code{uid}
\item \code{email}
\item \code{email_verified}
\item \code{created_by}
\item \code{created_at}
\item \code{modified_by}
\item \code{modified_at}
\item \code{is_password_set}
}
}
\description{
Polished API - Get User(s)
}
\details{
If both the \code{user_uid} and \code{email} are \code{NULL}, then all the
users in your account will be returned.  If either \code{user_uid} or \code{email} are not
\code{NULL}, then a single user will be returned (assuming the user exists).  If both the
\code{user_uid} and \code{email} are provided, then the \code{user_uid} will be used,
and the \code{email} will be ignored.  If the user does not exists, a zero row tibble
will be returned.
}
\seealso{
\code{\link[=add_user]{add_user()}} \code{\link[=delete_user]{delete_user()}}
}
