% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotcv.R, R/plotecdf.R, R/plotprcc.R,
%   R/plotscatter.R
\name{plotcv}
\alias{plotcv}
\alias{plotecdf}
\alias{plotprcc}
\alias{plotscatter}
\title{Uncertainty and Sensitivity Plots.}
\usage{
plotcv(obj, stack = FALSE, index.res = 1:get.noutputs(obj),
  col = index.res, quant = 0.99, ...)

plotecdf(obj, stack = FALSE, index.res = 1:get.noutputs(obj),
  col = index.res, xlab = NULL, ...)

plotprcc(obj, index.res = 1:dim(obj$res)[2], col = "orange", ylab = NULL,
  ...)

plotscatter(obj, res = NULL, index.data = NULL, index.res = NULL,
  add.lm = TRUE, ylab = NULL, ...)
}
\arguments{
\item{obj}{The LHS or PLUE object containing the simulation results to be plotted.

  NOTICE: plotecdf and plotcv only accept LHS objects! For plotting the likelihood profile
  from a PLUE object, simply use \code{plot(obj)}}

\item{stack}{If the results is a data.frame with several variables, \code{stack=FALSE} generates
a series of plots, and \code{stack=TRUE} generates a single plot with the ECDF from
all variables identified by different colors.}

\item{index.res}{An optional vector indicating which columns from the results are to be plotted.}

\item{col}{An optional vector indicating the colors to be used.}

\item{quant}{Maximum quantile to be plotted on the ecdf (used to cut off extreme values in the labels)}

\item{\dots}{Additional parameters to be passed to the lower level plotting function.}

\item{xlab, ylab}{Labels for the x axis (ecdf) or y axis(prcc). 
The functions use the name provided in the res.names argument from the LHS function if left blank.}

\item{res}{A data.frame consisting of the model results to be plotted on the y axis, if
'obj' is passed as a data.frame. If 'obj' is an LHS/PLUE object, this parameter is ignored.}

\item{index.data}{An optional vector with the indices of the data columns to be plotted.}

\item{add.lm}{Boolean. Whether to include a simple linear model on the plots. Defaults to TRUE.}
}
\description{
The functions listed here are used in uncertainty and sensitivity estimation.
}
\details{
The function \code{plotscatter} produces a series of scatterplots from data.

The function \code{plotecdf} plots the empirical cumulative density function
 from an LHS object	or PLUE object.

The function \code{plotprcc} plots the partial rank correlation coefficient
 from an LHS object	or PLUE object.

Finally, the \code{plotcv} function plots the empirical cummulative density function 
(ecdf) of the coefficient of variation of the LHS resulting from a stochastic 
simulation, along with a dotted line representing the coefficient of variation
of the whole result set. See the 'multiple' vignette for examples and interpretation.

The function plotscatter accepts an alternative invocation of \code{plotscatter(obj, res)}
in which obj is a data.frame consisting on the data to be plotted on the x axis, and 
res is a data.frame consisting on the model results to be plotted on the y axis.
}
\examples{
myLHS <- LHS(model=function(x) x[,1]+x[,2]*x[,3], factors=3, N=20, res.names="My Output")
plotecdf(myLHS, main="ECDF plot")
plotprcc(myLHS, main="PRCC plot")
plotscatter(myLHS)
}
