% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pystr_center.R
\name{pystr_center}
\alias{pystr_center}
\title{Center a string.}
\usage{
pystr_center(str, width, fillchar = " ")
}
\arguments{
\item{str}{A character vector.}

\item{width}{An integer.}

\item{fillchar}{A character string.}
}
\value{
A character vector.
}
\description{
Return \code{str} centered in a string of length \code{width}.
}
\details{
Padding is done using the specified \code{fillchar} (default is an ASCII space).
The original string is returned if \code{width} is less than or equal to \code{nchar(str)}.
}
\examples{
pystr_center("center me", 15)
pystr_center("center me", 15, "*")
}
\references{
\url{https://docs.python.org/3/library/stdtypes.html#str.center}
}
\seealso{
\code{\link{pystr_ljust}}, \code{\link{pystr_rjust}}
}

