% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_sgv_est_Function.R
\name{calc_sgv}
\alias{calc_sgv}
\title{Compute the standardized generalized variance (SGV) of a blocked diagonal matrix.}
\usage{
calc_sgv(nblocks = NULL, blksizes = NULL, vmat)
}
\arguments{
\item{nblocks}{Number of blocks in the matrix.}

\item{blksizes}{vector of block sizes}

\item{vmat}{The blocked covariance matrix}
}
\value{
The SGV of the covariance matrix \code{vmat}.
}
\description{
Compute the standardized generalized variance (SGV) of a blocked diagonal matrix.
}
\examples{
library(Matrix)
v1 = matrix(c(1,0.5,0.5,1), nrow = 2)
v2 = matrix(c(1,0.2,0.1,0.2,1,0.3,0.1,0.3,1), nrow = 3)
v3 = matrix(c(1,0.1,0.1,0.1,1,0.2,0.1,0.2,1), nrow = 3)
calc_sgv(nblocks = 3, blksizes = c(2,3,3), vmat = Matrix::bdiag(v1,v2,v3))
}

