% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readLevel2A.R
\name{readLevel2A}
\alias{readLevel2A}
\title{Read GEDI Level2A data (Basic Full Waveform derived Metrics)}
\usage{
readLevel2A(level2Apath)
}
\arguments{
\item{level2Apath}{File path pointing to GEDI level2A data. Data in HDF5 Hierarchical Data Format (.h5).}
}
\value{
Returns an S4 object of class "gedi.level2a" containing GEDI level2A data.
}
\description{
This function reads GEDI level2A products: ground elevation, canopy top height, and relative heights (RH).
}
\examples{
# Specifying the path to GEDI level2A data (zip file)
outdir = tempdir()
level2A_fp_zip <- system.file("extdata",
                  "GEDI02_A_2019108080338_O01964_T05337_02_001_01_sub.zip",
                  package="rGEDI")

# Unzipping GEDI level2A data
level2Apath <- unzip(level2A_fp_zip,exdir = outdir)

# Reading GEDI level2A data (h5 file)
level2a<-readLevel2A(level2Apath=level2Apath)

close(level2a)
}
\seealso{
https://lpdaac.usgs.gov/products/gedi02_av001/
}
