% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipLevel2A.R
\name{clipLevel2A}
\alias{clipLevel2A}
\title{Clip GEDI Level2A data by Coordinates}
\usage{
clipLevel2A(level2a, xmin, xmax, ymin, ymax, output)
}
\arguments{
\item{level2a}{A GEDI Level2A object (output of \code{\link[rGEDI:readLevel2A]{readLevel2A}} function).
An S4 object of class "gedi.level2a".}

\item{xmin}{Numeric. West longitude (x) coordinate of the bounding rectangle, in decimal degrees.}

\item{xmax}{Numeric. East longitude (x) coordinate of the bounding rectangle, in decimal degrees.}

\item{ymin}{Numeric. South latitude (y) coordinate of the bounding rectangle, in decimal degrees.}

\item{ymax}{Numeric. North latitude (y) coordinate of the bounding rectangle, in decimal degrees.}

\item{output}{Optional character path where to save the new hdf5file. The default stores a temporary file only.}
}
\value{
Returns a list of S4 objects of class "gedi.level2a" containing clipped GEDI Level2A data.
}
\description{
This function clips GEDI Level2A data within a given bounding coordinates
}
\examples{
\donttest{
outdir = tempdir()

# Specifying the path to GEDI level2A data (zip file)
level2A_fp_zip <- system.file("extdata",
                  "GEDI02_A_2019108080338_O01964_T05337_02_001_01_sub.zip",
                  package="rGEDI")

# Unzipping GEDI level2A data
level2Apath <- unzip(level2A_fp_zip,exdir = outdir)

# Reading GEDI level2A data (h5 file)
level2a<-readLevel2A(level2Apath=level2Apath)

# Bounding rectangle coordinates
xmin=-44.13
xmax=-44.12
ymin=-13.74
ymax=-13.73

# Specifying output file and path
output<-file.path(outdir,"GEDI02_A_2019108080338_O01964_T05337_02_001_01_clip.h5")

# Clipping GEDI Level2A data by boundary box extent
level2a_clip <- clipLevel2A(level2a,xmin,xmax,ymin,ymax,output)

close(level2a)
close(level2a_clip)
}
}
\seealso{
https://lpdaac.usgs.gov/products/gedi02_av001/
}
