% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.si.sp.R
\name{beta.si.sp}
\alias{beta.si.sp}
\title{beta input for MCNP  '}
\usage{
beta.si.sp(desired_RN, erg_dist = 1)
}
\arguments{
\item{desired_RN}{The radionuclide of interest in format element-isotope, 
followed by m if metastable. 
Must be in quotes, e.g. "Pa-234m"}

\item{erg_dist}{Energy distribution number. Defaults to 1. Helpful if several
isotopes are used in a single MCNP input.}
}
\value{
A text file, si.sp.dat, is written to the user's working file. It
  contains an energy distribution in a format compliant with MCNP. New data
  is appended to any exising data in the file if it already exists.
}
\description{
Make beta energy distribution for MCNP input '
}
\examples{
beta.si.sp("Sr-90", erg_dist = 11)
beta.si.sp("Y-90",  erg_dist = 13)
beta.si.sp("C-14",  erg_dist = 15)
}
