% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcnp_si_hist.R
\name{mcnp_si_hist}
\alias{mcnp_si_hist}
\title{energy distribution histogram entries}
\usage{
mcnp_si_hist(emin, emax)
}
\arguments{
\item{emin}{A vector of energies forming the lower bound of the bin. (emin values other than the first value also provide a bin emax.)}

\item{emax}{A single energy with the upper bound of the highest bin.}
}
\value{
A matrix of values for source input to copy and paste into an MCNP input. (The # should be changed to the appropriate distribution number. The NA's in the last row should be discarded.)
}
\description{
Make MCNP histogram energy bins cards for source definition if inputs happen to be available in histogram format.
}
\examples{
mcnp_si_hist(1:10 / 10, 1.2)
}
\seealso{
[mcnp_sp_hist()]

Other mcnp tools: \code{\link{mcnp_cone_angle}},
  \code{\link{mcnp_est_nps}},
  \code{\link{mcnp_matrix_rotations}},
  \code{\link{mcnp_plot_out_spec}},
  \code{\link{mcnp_scan2spec}},
  \code{\link{mcnp_si_sp_RD}}, \code{\link{mcnp_sp_hist}}
}
\concept{mcnp tools}
