% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcnp_matrix_rotations.R
\name{mcnp_matrix_rotations}
\alias{mcnp_matrix_rotations}
\title{Rotation matrices for transformations in MCNP}
\usage{
mcnp_matrix_rotations(rot.axis, angle_degrees)
}
\arguments{
\item{rot.axis}{axis of rotation}

\item{angle_degrees}{degree of rotation}
}
\value{
rotational matrix for copy and paste to MCNP input
}
\description{
Create 3 x 3 rotation matrix in cosines of the angles
between the main and auxiliary coordinate systems in the form:
xx' yx' zx'
xy' yy' zy'
xz' yz' zz'
}
\examples{
mcnp_matrix_rotations("x", 30)
mcnp_matrix_rotations("y", 7)
mcnp_matrix_rotations("z", 15)
# For combined rotations, use matrix multiplication (\%*\%)
# rotate 45 degrees on x-axis and 45 degrees on y-axis
mcnp_matrix_rotations("x", 45) \%*\% mcnp_matrix_rotations("y", 45)
}
\seealso{
Other mcnp tools: 
\code{\link{mcnp_cone_angle}()},
\code{\link{mcnp_est_nps}()},
\code{\link{mcnp_plot_out_spec}()},
\code{\link{mcnp_scan2plot}()},
\code{\link{mcnp_scan_save}()},
\code{\link{mcnp_sdef_erg_hist}()},
\code{\link{mcnp_sdef_erg_line}()},
\code{\link{mcnp_si_sp_RD}()},
\code{\link{mcnp_si_sp_hist_scan}()},
\code{\link{mcnp_si_sp_hist}()}
}
\concept{mcnp tools}
