/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.datastream.filereaders;

import eu.amidst.core.datastream.Attributes;
import eu.amidst.core.datastream.filereaders.DataRow;
import eu.amidst.core.utils.FixedBatchParallelSpliteratorWrapper;
import java.util.Iterator;
import java.util.stream.Stream;

public interface DataFileReader
extends Iterable<DataRow> {
    public void loadFromFile(String var1);

    public Attributes getAttributes();

    public boolean doesItReadThisFile(String var1);

    public Stream<DataRow> stream();

    default public void restart() {
    }

    default public void close() {
    }

    default public Stream<DataRow> parallelStream(int batchSize) {
        return FixedBatchParallelSpliteratorWrapper.toFixedBatchStream(this.stream(), batchSize);
    }

    default public Stream<DataRow> parallelStream() {
        return (Stream)this.stream().parallel();
    }

    @Override
    default public Iterator<DataRow> iterator() {
        return this.stream().iterator();
    }
}

