/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.variables;

import eu.amidst.core.utils.Utils;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.Variable;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class HashMapAssignment
implements Assignment,
Serializable {
    private static final long serialVersionUID = -3436599636425587512L;
    private Map<Variable, Double> assignment;

    public HashMapAssignment() {
        this.assignment = new ConcurrentHashMap<Variable, Double>();
    }

    public HashMapAssignment(int nOfVars) {
        this.assignment = new ConcurrentHashMap<Variable, Double>(nOfVars);
    }

    public HashMapAssignment(Assignment assignment1) {
        Set<Variable> variableList = assignment1.getVariables();
        this.assignment = new ConcurrentHashMap<Variable, Double>(variableList.size());
        for (Variable var : variableList) {
            this.setValue(var, assignment1.getValue(var));
        }
    }

    @Override
    public double getValue(Variable key) {
        Double val = this.assignment.get(key);
        if (val != null) {
            return val;
        }
        return Utils.missingValue();
    }

    @Override
    public void setValue(Variable var, double val) {
        this.assignment.put(var, val);
    }

    @Override
    public Set<Variable> getVariables() {
        return this.assignment.keySet();
    }

    public Set<Map.Entry<Variable, Double>> entrySet() {
        return this.assignment.entrySet();
    }
}

