/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.models;

import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.distribution.Distribution;
import eu.amidst.core.models.BayesianNetwork;
import eu.amidst.core.models.DAG;
import eu.amidst.core.utils.Serialization;
import eu.amidst.core.utils.Utils;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.Variable;
import eu.amidst.dynamic.models.DynamicDAG;
import eu.amidst.dynamic.variables.DynamicVariables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

public final class DynamicBayesianNetwork
implements Serializable {
    private static final long serialVersionUID = 4968590066969071698L;
    private List<ConditionalDistribution> distributionsTime0;
    private List<ConditionalDistribution> distributionsTimeT;
    private DynamicDAG dynamicDAG;

    public DynamicBayesianNetwork(DynamicDAG dynamicDAG1) {
        this.dynamicDAG = dynamicDAG1;
        this.initializeDistributions();
    }

    public DynamicBayesianNetwork(DynamicDAG dynamicDAG1, List<ConditionalDistribution> distsTime0, List<ConditionalDistribution> distsTimeT) {
        this.dynamicDAG = dynamicDAG1;
        this.distributionsTime0 = distsTime0;
        this.distributionsTimeT = distsTimeT;
    }

    public BayesianNetwork toBayesianNetworkTime0() {
        DAG dagTime0 = this.getDynamicDAG().toDAGTime0();
        BayesianNetwork bnTime0 = new BayesianNetwork(dagTime0);
        for (Variable dynamicVar : this.getDynamicVariables()) {
            Variable staticVar = dagTime0.getVariables().getVariableByName(dynamicVar.getName());
            ConditionalDistribution deepCopy = (ConditionalDistribution)Serialization.deepCopy(this.getConditionalDistributionTime0(dynamicVar));
            deepCopy.setVar(staticVar);
            List<Variable> newParents = deepCopy.getConditioningVariables().stream().map(var -> dagTime0.getVariables().getVariableByName(var.getName())).collect(Collectors.toList());
            deepCopy.setConditioningVariables(newParents);
            bnTime0.setConditionalDistribution(staticVar, deepCopy);
        }
        return bnTime0;
    }

    public BayesianNetwork toBayesianNetworkTimeT() {
        DAG dagTimeT = this.getDynamicDAG().toDAGTimeT();
        BayesianNetwork bnTimeT = new BayesianNetwork(dagTimeT);
        for (Variable dynamicVar : this.getDynamicVariables()) {
            Variable staticVar = dagTimeT.getVariables().getVariableByName(dynamicVar.getName());
            ConditionalDistribution deepCopy = (ConditionalDistribution)Serialization.deepCopy(this.getConditionalDistributionTimeT(dynamicVar));
            deepCopy.setVar(staticVar);
            List<Variable> newParents = deepCopy.getConditioningVariables().stream().map(var -> dagTimeT.getVariables().getVariableByName(var.getName())).collect(Collectors.toList());
            deepCopy.setConditioningVariables(newParents);
            bnTimeT.setConditionalDistribution(staticVar, deepCopy);
        }
        return bnTimeT;
    }

    private void initializeDistributions() {
        this.distributionsTime0 = new ArrayList<ConditionalDistribution>(this.getDynamicVariables().getNumberOfVars());
        this.distributionsTimeT = new ArrayList<ConditionalDistribution>(this.getDynamicVariables().getNumberOfVars());
        for (Variable var : this.getDynamicVariables()) {
            int varID = var.getVarID();
            this.distributionsTimeT.add(varID, (ConditionalDistribution)var.newConditionalDistribution(this.dynamicDAG.getParentSetTimeT(var).getParents()));
            this.dynamicDAG.getParentSetTimeT(var).blockParents();
            this.distributionsTime0.add(varID, (ConditionalDistribution)var.newConditionalDistribution(this.dynamicDAG.getParentSetTime0(var).getParents()));
            this.dynamicDAG.getParentSetTime0(var).blockParents();
        }
    }

    public void setConditionalDistributionTime0(Variable var, ConditionalDistribution dist) {
        this.distributionsTime0.set(var.getVarID(), dist);
    }

    public void setConditionalDistributionTimeT(Variable var, ConditionalDistribution dist) {
        this.distributionsTimeT.set(var.getVarID(), dist);
    }

    public void setName(String name) {
        this.dynamicDAG.setName(name);
    }

    public String getName() {
        return this.dynamicDAG.getName();
    }

    public int getNumberOfDynamicVars() {
        return this.getDynamicVariables().getNumberOfVars();
    }

    public DynamicVariables getDynamicVariables() {
        return this.dynamicDAG.getDynamicVariables();
    }

    public <E extends ConditionalDistribution> E getConditionalDistributionTimeT(Variable var) {
        return (E)this.distributionsTimeT.get(var.getVarID());
    }

    public <E extends ConditionalDistribution> E getConditionalDistributionTime0(Variable var) {
        return (E)this.distributionsTime0.get(var.getVarID());
    }

    public DynamicDAG getDynamicDAG() {
        return this.dynamicDAG;
    }

    public int getNumberOfVars() {
        return this.getDynamicVariables().getNumberOfVars();
    }

    public double getLogProbabiltyOfFullAssignmentTimeT(Assignment assignment) {
        double logProb = 0.0;
        for (Variable var : this.getDynamicVariables()) {
            if (assignment.getValue(var) == Utils.missingValue()) {
                throw new UnsupportedOperationException("This method can not compute the probabilty of a partial assignment.");
            }
            logProb += this.distributionsTimeT.get(var.getVarID()).getLogConditionalProbability(assignment);
        }
        return logProb;
    }

    public double getLogProbabiltyOfFullAssignmentTime0(Assignment assignment) {
        double logProb = 0.0;
        for (Variable var : this.getDynamicVariables()) {
            if (assignment.getValue(var) == Utils.missingValue()) {
                throw new UnsupportedOperationException("This method can not compute the probabilty of a partial assignment.");
            }
            logProb += this.distributionsTime0.get(var.getVarID()).getLogConditionalProbability(assignment);
        }
        return logProb;
    }

    public List<ConditionalDistribution> getConditionalDistributionsTimeT() {
        return this.distributionsTimeT;
    }

    public List<ConditionalDistribution> getConditionalDistributionsTime0() {
        return this.distributionsTime0;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Dynamic Bayesian Network Time 0:\n");
        for (Variable var : this.getDynamicVariables()) {
            if (this.getDynamicDAG().getParentSetTime0(var).getNumberOfParents() == 0) {
                str.append("P(" + var.getName() + ") follows a ");
                str.append(((Distribution)this.getConditionalDistributionTime0(var)).label() + "\n");
            } else {
                str.append("P(" + var.getName() + " | ");
                for (Variable parent : this.getDynamicDAG().getParentSetTime0(var)) {
                    str.append(parent.getName() + " , ");
                }
                if (this.getDynamicDAG().getParentSetTime0(var).getNumberOfParents() > 0) {
                    str.delete(str.length() - 3, str.length());
                }
                str.append(") follows a ");
                str.append(((Distribution)this.getConditionalDistributionTime0(var)).label() + "\n");
            }
            str.append(((Distribution)this.getConditionalDistributionTime0(var)).toString() + "\n");
        }
        str.append("\nDynamic Bayesian Network Time T:\n");
        for (Variable var : this.getDynamicVariables()) {
            if (this.getDynamicDAG().getParentSetTimeT(var).getNumberOfParents() == 0) {
                str.append("P(" + var.getName() + ") follows a ");
                str.append(((Distribution)this.getConditionalDistributionTimeT(var)).label() + "\n");
            } else {
                str.append("P(" + var.getName() + " | ");
                for (Variable parent : this.getDynamicDAG().getParentSetTimeT(var)) {
                    str.append(parent.getName() + " , ");
                }
                if (this.getDynamicDAG().getParentSetTimeT(var).getNumberOfParents() > 0) {
                    str.delete(str.length() - 3, str.length());
                }
                str.append(") follows a ");
                str.append(((Distribution)this.getConditionalDistributionTimeT(var)).label() + "\n");
            }
            str.append(((Distribution)this.getConditionalDistributionTimeT(var)).toString() + "\n");
        }
        return str.toString();
    }

    public void randomInitialization(Random random) {
        this.distributionsTimeT.stream().forEach(w -> w.randomInitialization(random));
        this.distributionsTime0.stream().forEach(w -> w.randomInitialization(random));
    }

    public boolean equalDBNs(DynamicBayesianNetwork bnet, double threshold) {
        boolean equals = true;
        if (this.getDynamicDAG().equals(bnet.getDynamicDAG())) {
            for (Variable var : this.getDynamicVariables()) {
                equals = equals && ((Distribution)this.getConditionalDistributionTime0(var)).equalDist((Distribution)bnet.getConditionalDistributionTime0(var), threshold) && ((Distribution)this.getConditionalDistributionTimeT(var)).equalDist((Distribution)bnet.getConditionalDistributionTimeT(var), threshold);
            }
        }
        return equals;
    }
}

