/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.controller.ControllerModuleAdapter;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.edit.CompositEdit;
import org.openscience.cdk.controller.edit.Merge;
import org.openscience.cdk.controller.edit.Move;
import org.openscience.cdk.controller.edit.OptionalUndoEdit;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class MoveModule
extends ControllerModuleAdapter {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(MoveModule.class);
    private Vector2d offset;
    private Set<IAtom> atomsToMove;
    private Point2d start2DCenter;

    public MoveModule(IChemModelRelay chemObjectRelay) {
        super(chemObjectRelay);
    }

    @Override
    public void mouseClickedDown(Point2d worldCoord) {
        IAtomContainer selectedAC = this.getSelectedAtomContainer(worldCoord);
        if (selectedAC != null) {
            Point2d current;
            this.atomsToMove = new HashSet<IAtom>();
            for (IAtom atom : selectedAC.atoms()) {
                this.atomsToMove.add(atom);
            }
            for (IBond bond : selectedAC.bonds()) {
                for (IAtom atom : bond.atoms()) {
                    this.atomsToMove.add(atom);
                }
            }
            this.start2DCenter = current = GeometryTools.get2DCenter((IAtomContainer)selectedAC);
            this.offset = new Vector2d();
            this.offset.sub(current, worldCoord);
        } else {
            this.endMove();
        }
    }

    @Override
    public void mouseClickedUp(Point2d worldCoord) {
        if (this.start2DCenter != null) {
            Vector2d end = new Vector2d();
            Point2d end2DCenter = GeometryTools.get2DCenter(this.atomsToMove);
            end.sub(end2DCenter, this.start2DCenter);
            Map<IAtom, IAtom> mergeMap = this.chemModelRelay.getRenderer().getRenderer2DModel().getMerge();
            if (!mergeMap.isEmpty()) {
                Vector2d shift = MoveModule.calcualteShift(mergeMap);
                OptionalUndoEdit smallMove = OptionalUndoEdit.wrapNonFinal(Move.move(shift, this.atomsToMove));
                shift.add(end);
                OptionalUndoEdit shiftEdit = OptionalUndoEdit.wrapFinal(Move.move(shift, this.atomsToMove));
                Merge mergeEdit = Merge.merge(mergeMap);
                mergeMap.clear();
                this.chemModelRelay.execute(CompositEdit.compose(smallMove, shiftEdit, mergeEdit));
            } else {
                OptionalUndoEdit edit = OptionalUndoEdit.wrapFinal(Move.move(end, this.atomsToMove));
                this.chemModelRelay.execute(edit);
            }
        }
        this.endMove();
    }

    public static Vector2d calcualteShift(Map<IAtom, IAtom> mergeMap) {
        Iterator<IAtom> it = mergeMap.keySet().iterator();
        if (!it.hasNext()) {
            return new Vector2d();
        }
        IAtom atomA = it.next();
        IAtom atomB = mergeMap.get(atomA);
        Vector2d shift = new Vector2d();
        shift.sub(atomB.getPoint2d(), atomA.getPoint2d());
        return shift;
    }

    private void endMove() {
        this.start2DCenter = null;
        this.selection = null;
        this.offset = null;
    }

    @Override
    public void mouseDrag(Point2d worldCoordFrom, Point2d worldCoordTo) {
        if (this.chemModelRelay != null && this.offset != null) {
            Point2d atomCoord = new Point2d();
            atomCoord.add(worldCoordTo, this.offset);
            Vector2d d = new Vector2d();
            d.sub(worldCoordTo, worldCoordFrom);
            OptionalUndoEdit edit = OptionalUndoEdit.wrapNonFinal(Move.move(d, this.atomsToMove));
            RendererModel model = this.chemModelRelay.getRenderer().getRenderer2DModel();
            model.getMerge().clear();
            model.getMerge().putAll(MoveModule.calculateMerge(this.atomsToMove, this.getModel(), this.getHighlightDistance()));
            this.chemModelRelay.execute(edit);
        } else if (this.chemModelRelay == null) {
            this.logger.debug((Object)"chemObjectRelay is NULL!");
        }
    }

    public static Map<IAtom, IAtom> calculateMerge(IAtomContainer ac1, IAtomContainer ac2, double maxDistance) {
        HashSet<IAtom> atoms = new HashSet<IAtom>();
        for (IAtom atom : ac1.atoms()) {
            atoms.add(atom);
        }
        return MoveModule.calculateMerge(atoms, ac2, maxDistance);
    }

    public static Map<IAtom, IAtom> calculateMerge(Collection<IAtom> mergeAtoms, IAtomContainer ac, double maxDistance) {
        maxDistance *= maxDistance;
        double maxDistance2 = maxDistance;
        HashMap<IAtom, IAtom> mergers = new HashMap<IAtom, IAtom>();
        block0: for (IAtom atom : mergeAtoms) {
            List<DistAtom> candidates = MoveModule.findMergeCandidates(ac, atom);
            Collections.sort(candidates);
            for (DistAtom candiate : candidates) {
                if (candiate.distSquared > maxDistance2) continue block0;
                if (mergeAtoms.contains(candiate.atom)) continue;
                mergers.put(atom, candiate.atom);
            }
        }
        return mergers;
    }

    private static List<DistAtom> findMergeCandidates(IAtomContainer set, IAtom atom) {
        ArrayList<DistAtom> candidates = new ArrayList<DistAtom>();
        for (IAtom candidate : set.atoms()) {
            double disSquare = candidate.getPoint2d().distanceSquared(atom.getPoint2d());
            candidates.add(new DistAtom(candidate, disSquare));
        }
        return candidates;
    }

    @Override
    public String getDrawModeString() {
        return "Move";
    }

    public static class DistAtom
    implements Comparable<DistAtom> {
        IAtom atom;
        double distSquared;

        public DistAtom(IAtom atom, double distSquared) {
            this.atom = atom;
            this.distSquared = distSquared;
        }

        @Override
        public int compareTo(DistAtom o) {
            if (this.distSquared < o.distSquared) {
                return -1;
            }
            if (this.distSquared > o.distSquared) {
                return 1;
            }
            return 0;
        }
    }
}

