/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openscience.cdk.controller.Changed;
import org.openscience.cdk.controller.edit.AbstractEdit;
import org.openscience.cdk.controller.edit.IEdit;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

public class CompositEdit
extends AbstractEdit {
    private List<IEdit> edits;

    @Override
    public Set<Changed> getTypeOfChanges() {
        HashSet<Changed> composit = new HashSet<Changed>();
        for (IEdit edit : this.edits) {
            composit.addAll(edit.getTypeOfChanges());
        }
        return composit;
    }

    public static CompositEdit compose(IEdit ... edits) {
        CompositEdit cEdit = new CompositEdit();
        cEdit.edits = Arrays.asList(edits);
        return cEdit;
    }

    public static CompositEdit compose(List<? extends IEdit> edits) {
        CompositEdit cEdit = new CompositEdit();
        cEdit.edits = new ArrayList<IEdit>(edits);
        return cEdit;
    }

    @Override
    public void execute(IAtomContainer ac) {
        for (IEdit edit : this.edits) {
            edit.execute(ac);
        }
    }

    @Override
    public void redo() {
        for (IEdit edit : this.edits) {
            edit.redo();
        }
    }

    @Override
    public void undo() {
        ArrayList<IEdit> reverse = new ArrayList<IEdit>(this.edits);
        Collections.reverse(reverse);
        for (IEdit edit : reverse) {
            edit.undo();
        }
    }

    @Override
    public Collection<IAtom> getAtomsToUpdate() {
        ArrayList<IAtom> atoms = new ArrayList<IAtom>();
        for (IEdit edit : this.edits) {
            atoms.addAll(edit.getAtomsToUpdate());
        }
        return atoms;
    }
}

