/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.edit;

import java.util.List;
import java.util.Set;
import org.openscience.cdk.controller.Changed;
import org.openscience.cdk.controller.edit.AbstractEdit;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.ISingleElectron;

public class RemoveSingleElectron
extends AbstractEdit {
    ISingleElectron oldElectron;
    IAtom atom;

    public static RemoveSingleElectron removeElectron(IAtom atom) {
        return new RemoveSingleElectron(atom);
    }

    public RemoveSingleElectron(IAtom atom) {
        this.atom = atom;
    }

    @Override
    public Set<Changed> getTypeOfChanges() {
        return RemoveSingleElectron.changed(Changed.Properties, Changed.Structure);
    }

    @Override
    public void redo() {
        List electrons = this.model.getConnectedSingleElectronsList(this.atom);
        if (!electrons.isEmpty()) {
            this.oldElectron = (ISingleElectron)electrons.get(electrons.size() - 1);
            this.model.removeSingleElectron(this.oldElectron);
            this.updateHydrogenCount(this.atom);
        }
    }

    @Override
    public void undo() {
        if (this.oldElectron != null) {
            this.model.addSingleElectron(this.oldElectron);
            this.updateHydrogenCount(this.atom);
        }
    }
}

