/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.vflib.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.smsd.algorithm.matchers.VFAtomMatcher;
import org.openscience.cdk.smsd.algorithm.vflib.builder.EdgeBuilder;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.IEdge;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.INode;

@TestClass(value="org.openscience.cdk.smsd.algorithm.vflib.VFLibTest")
public class NodeBuilder
implements INode {
    private List<INode> neighborsList;
    private List<IEdge> edgesList = new ArrayList<IEdge>();
    private VFAtomMatcher matcher;

    protected NodeBuilder(VFAtomMatcher matcher) {
        this.neighborsList = new ArrayList<INode>();
        this.matcher = matcher;
    }

    @Override
    public int countNeighbors() {
        return this.neighborsList.size();
    }

    @Override
    public Iterable<INode> neighbors() {
        return Collections.unmodifiableList(this.neighborsList);
    }

    @Override
    public VFAtomMatcher getAtomMatcher() {
        return this.matcher;
    }

    @Override
    public List<IEdge> getEdges() {
        return Collections.unmodifiableList(this.edgesList);
    }

    @Override
    public void addEdge(EdgeBuilder edge) {
        this.edgesList.add(edge);
    }

    @Override
    public void addNeighbor(NodeBuilder node) {
        this.neighborsList.add(node);
    }
}

