/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.edit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.controller.Changed;
import org.openscience.cdk.controller.edit.AbstractEdit;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class Merge
extends AbstractEdit {
    Map<IAtom, IAtom> mergeModel;
    List<IBond> deletedBonds;
    Map<IBond, ReplacedAtom> modifiedBonds;

    public static Merge merge(Map<IAtom, IAtom> mergeModel) {
        return new Merge(mergeModel);
    }

    private Merge(Map<IAtom, IAtom> mergeModel) {
        this.mergeModel = new HashMap<IAtom, IAtom>(mergeModel);
    }

    @Override
    public Set<Changed> getTypeOfChanges() {
        return Merge.changed(Changed.Structure, Changed.Properties);
    }

    @Override
    public void redo() {
        this.mergeMolecules(this.mergeModel);
        ArrayList<IAtom> atoms = new ArrayList<IAtom>();
        atoms.addAll(this.mergeModel.values());
        this.updateHydrogenCount(atoms);
    }

    @Override
    public void undo() {
        for (IAtom atom : this.mergeModel.keySet()) {
            this.model.addAtom(atom);
        }
        for (IBond bond : this.deletedBonds) {
            this.model.addBond(bond);
        }
        for (IBond bond : this.modifiedBonds.keySet()) {
            ReplacedAtom replaced = this.modifiedBonds.get(bond);
            bond.setAtom(replaced.oldAtom, replaced.positionInBond);
        }
        ArrayList<IAtom> atoms = new ArrayList<IAtom>();
        atoms.addAll(this.mergeModel.keySet());
        atoms.addAll(this.mergeModel.values());
        this.updateHydrogenCount(atoms);
    }

    public void mergeMolecules(Map<IAtom, IAtom> mergeModel) {
        this.deletedBonds = new ArrayList<IBond>();
        this.modifiedBonds = new HashMap<IBond, ReplacedAtom>();
        IAtomContainer container = this.model;
        for (IAtom mergedAtom : mergeModel.keySet()) {
            IAtom mergedPartnerAtom = mergeModel.get(mergedAtom);
            for (IAtom atom2 : mergeModel.keySet()) {
                IBond bond;
                IBond bondPartner = this.model.getBond(mergeModel.get(mergedAtom), mergeModel.get(atom2));
                if (bondPartner == null || (bond = this.model.getBond(mergedAtom, atom2)) == null) continue;
                this.model.removeBond(bond);
                this.deletedBonds.add(bond);
            }
            for (IBond bond : container.bonds()) {
                if (!bond.contains(mergedAtom)) continue;
                if (bond.getAtom(0).equals(mergedAtom)) {
                    bond.setAtom(mergedPartnerAtom, 0);
                    this.modifiedBonds.put(bond, new ReplacedAtom(mergedAtom, 0));
                    continue;
                }
                bond.setAtom(mergedPartnerAtom, 1);
                this.modifiedBonds.put(bond, new ReplacedAtom(mergedAtom, 1));
            }
            container.removeAtom(mergedAtom);
        }
    }

    private static class ReplacedAtom {
        final IAtom oldAtom;
        final int positionInBond;

        public ReplacedAtom(IAtom atom, int pos) {
            this.oldAtom = atom;
            this.positionInBond = pos;
        }
    }
}

