/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.base.CMLType;
import org.xmlcml.cml.element.AbstractProperty;
import org.xmlcml.cml.element.CMLPropertyList;
import org.xmlcml.cml.element.CMLScalar;
import org.xmlcml.cml.interfacex.HasArraySize;
import org.xmlcml.cml.interfacex.HasDataType;
import org.xmlcml.cml.interfacex.HasScalar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLProperty
extends AbstractProperty {
    public static final String NS = "cml:property";
    private HasDataType child;

    public CMLProperty() {
    }

    public CMLProperty(CMLProperty old) {
        super(old);
    }

    public CMLProperty(String dictRef, double value, String units) {
        this();
        CMLScalar scalar = new CMLScalar(value);
        scalar.setUnits(units);
        this.appendChild(scalar);
        this.setDictRef(dictRef);
    }

    @Override
    public Node copy() {
        return new CMLProperty(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLProperty();
    }

    public static CMLPropertyList getPropertyList(CMLElement parent, String dictRef) {
        CMLPropertyList propertyList = new CMLPropertyList();
        Nodes nodes = parent.query("./cml:property", CML_XPATH);
        for (int i = 0; i < nodes.size(); ++i) {
            CMLProperty property = (CMLProperty)nodes.get(i);
            property.canonicalize();
            if (!dictRef.equals(property.getAttributeValue("dictRef"))) continue;
            propertyList.addProperty(property);
        }
        return propertyList;
    }

    public static CMLProperty getProperty(CMLElement parent, String dictRef) {
        CMLPropertyList propertyList = CMLProperty.getPropertyList(parent, dictRef);
        CMLElements<CMLProperty> properties = propertyList.getPropertyElements();
        CMLProperty property = null;
        if (properties.size() == 1) {
            property = properties.get(0);
        }
        return property;
    }

    public void canonicalize() {
        this.getChild();
        if (this.child != null) {
            String thisDictRef = this.getDictRef();
            String childDictRef = this.child.getDictRef();
            if (thisDictRef == null) {
                if (childDictRef == null) {
                    throw new RuntimeException("No dictRef attribute given: ");
                }
                this.setDictRef(childDictRef);
            } else if (childDictRef != null && !thisDictRef.equals(childDictRef)) {
                throw new RuntimeException("inconsistent dictRefs: " + thisDictRef + " // " + childDictRef);
            }
            String units = this.getUnits();
            String dataType = CMLType.getNormalizedValue(this.child.getDataType());
            if (units != null) {
                if (!dataType.equals("xsd:double")) {
                    this.child.setDataType("xsd:double");
                    throw new RuntimeException("units require data type of double");
                }
            } else if (dataType.equals("xsd:double")) {
                throw new RuntimeException("dataType not double");
            }
        }
    }

    public String getUnits() {
        this.getChild();
        String units = ((CMLElement)((Object)this.child)).getAttributeValue("units");
        return units;
    }

    public double getDouble() {
        this.getChild();
        double result = Double.NaN;
        String dataType = CMLType.getNormalizedValue(this.child.getDataType());
        if ("xsd:double".equals(dataType) && this.child instanceof HasScalar) {
            result = ((HasScalar)this.child).getDouble();
        }
        return result;
    }

    public String getString() {
        this.getChild();
        String result = null;
        if ("xsd:string".equals(this.child.getDataType()) && this.child instanceof HasScalar) {
            result = ((HasScalar)this.child).getString();
        }
        return result;
    }

    public int getInt() {
        this.getChild();
        int result = Integer.MIN_VALUE;
        String dataType = CMLType.getNormalizedValue(this.child.getDataType());
        if ("xsd:integer".equals(dataType) && this.child instanceof HasScalar) {
            result = ((HasScalar)this.child).getInt();
        }
        return result;
    }

    public List<String> getStringValues() {
        this.getChild();
        List<String> result = null;
        String dataType = CMLType.getNormalizedValue(this.child.getDataType());
        if ("xsd:string".equals(dataType) && this.child instanceof HasArraySize) {
            result = ((HasArraySize)this.child).getStringValues();
        }
        return result;
    }

    public int[] getInts() {
        this.getChild();
        int[] result = null;
        String dataType = CMLType.getNormalizedValue(this.child.getDataType());
        if ("xsd:integer".equals(dataType) && this.child instanceof HasArraySize) {
            result = ((HasArraySize)this.child).getInts();
        }
        return result;
    }

    public double[] getDoubles() {
        this.getChild();
        double[] result = null;
        String dataType = CMLType.getNormalizedValue(this.child.getDataType());
        if ("xsd:double".equals(dataType) && this.child instanceof HasArraySize) {
            result = ((HasArraySize)this.child).getDoubles();
        }
        return result;
    }

    public HasDataType getChild() {
        Nodes nodes;
        if (this.child == null && (nodes = this.query("cml:scalar | cml:array | cml:matrix", CML_XPATH)).size() == 1) {
            this.child = (HasDataType)((Object)nodes.get(0));
        }
        return this.child;
    }

    public void setChild(HasDataType child) {
        this.child = child;
    }

    public String getDataType() {
        this.getChild();
        String dataType = this.child == null ? null : this.child.getDataType();
        return CMLType.getNormalizedValue(dataType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Prop {
        DENSITY("cml:density"),
        MOLAR_MASS("cml:molarMass"),
        MOLAR_VOLUME("cml:molarVolume");

        public final String value;

        private Prop(String s) {
            this.value = s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INTENSIVE("intensive"),
        EXTENSIVE("extensive"),
        SEMINTENSIVE("semintensive");

        public String value;

        private Type(String t) {
            this.value = t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DictRef {
        APPEARANCE("appearance"),
        AUTO_IGNITION("autoIgnition"),
        BPT("bpt"),
        DENSITY("density"),
        DIPOLE("dipole"),
        FLASH_POINT("flashPoint"),
        KH("kh"),
        LOGP("logP"),
        LOGPOW("logPow"),
        MOLARMASS("molarMass"),
        MPT("mpt"),
        MWT("mwt"),
        PKA("pka"),
        PKB("pkb"),
        REFRACTIVE_INDEX("refractiveIndex"),
        RELATIVE_DENSITY("relativeDensity"),
        RELATIVE_VAPOUR_DENSITY("relativeVapourDensity"),
        SOLUBILITY("solubility"),
        VAPOR_PRESSURE("vaporPressure"),
        VISCOSITY("viscosity"),
        WATER_SOLUBILITY("waterSolubility");

        public String v;
        private Map<String, DictRef> map = new HashMap<String, DictRef>();

        private DictRef(String v) {
            this.v = v;
            this.map.put(v, this);
        }

        public DictRef get(String v) {
            return this.map.get(v);
        }
    }
}

