/*
 * Decompiled with CFR 0.152.
 */
package signature.chemistry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Molecule {
    private List<Atom> atoms = new ArrayList<Atom>();
    private List<Bond> bonds = new ArrayList<Bond>();
    public String name;

    public Molecule() {
    }

    public Molecule(String atomSymbol, int count) {
        this();
        int i = 0;
        while (i < count) {
            this.addAtom(atomSymbol);
            ++i;
        }
    }

    public Molecule(Molecule other) {
        this();
        for (Atom atom : other.atoms) {
            this.atoms.add(new Atom(atom.index, atom.symbol));
        }
        for (Bond bond : other.bonds) {
            Atom oA = this.atoms.get(bond.a.index);
            Atom oB = this.atoms.get(bond.b.index);
            this.bonds.add(new Bond(oA, oB, bond.order));
        }
    }

    public Molecule(Molecule other, int[] permutation) {
        this();
        int index;
        Atom[] permutedAtoms = new Atom[permutation.length];
        for (Atom atom : other.atoms) {
            index = permutation[atom.index];
            permutedAtoms[index] = new Atom(index, atom.symbol);
        }
        Atom[] atomArray = permutedAtoms;
        index = permutedAtoms.length;
        int n = 0;
        while (n < index) {
            Atom atom;
            atom = atomArray[n];
            this.atoms.add(atom);
            ++n;
        }
        for (Bond bond : other.bonds) {
            Atom oA = this.atoms.get(permutation[bond.a.index]);
            Atom oB = this.atoms.get(permutation[bond.b.index]);
            this.bonds.add(new Bond(oA, oB, bond.order));
        }
    }

    public int getAtomCount() {
        return this.atoms.size();
    }

    public int getBondCount() {
        return this.bonds.size();
    }

    public List<Bond> bonds() {
        return this.bonds;
    }

    public int[] getConnected(int atomIndex) {
        ArrayList<Integer> connectedList = new ArrayList<Integer>();
        for (Bond bond : this.bonds) {
            int connectedIndex = bond.getConnected(atomIndex);
            if (connectedIndex == -1) continue;
            connectedList.add(connectedIndex);
        }
        int[] connected = new int[connectedList.size()];
        int i = 0;
        while (i < connectedList.size()) {
            connected[i] = (Integer)connectedList.get(i);
            ++i;
        }
        return connected;
    }

    public boolean isConnected(int i, int j) {
        for (Bond bond : this.bonds) {
            if (!bond.hasBoth(i, j)) continue;
            return true;
        }
        return false;
    }

    public int getBondOrder(int atomIndex, int otherAtomIndex) {
        for (Bond bond : this.bonds) {
            if (!bond.hasBoth(atomIndex, otherAtomIndex)) continue;
            return bond.order;
        }
        return -1;
    }

    public int getTotalOrder(int atomIndex) {
        int totalOrder = 0;
        for (Bond bond : this.bonds) {
            if (bond.a.index != atomIndex && bond.b.index != atomIndex) continue;
            totalOrder += bond.order;
        }
        return totalOrder;
    }

    public String getSymbolFor(int atomIndex) {
        return this.atoms.get((int)atomIndex).symbol;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Atom a : this.atoms) {
            buffer.append(a).append("|");
        }
        Collections.sort(this.bonds);
        for (Bond b : this.bonds) {
            buffer.append(b).append("|");
        }
        return buffer.toString();
    }

    public void addAtom(String symbol) {
        int i = this.atoms.size();
        this.addAtom(i, symbol);
    }

    public void addAtom(int i, String symbol) {
        this.atoms.add(new Atom(i, symbol));
    }

    public void addMultipleAtoms(int count, String symbol) {
        int i = 0;
        while (i < count) {
            this.addAtom(symbol);
            ++i;
        }
    }

    public void addSingleBond(int atomNumberA, int atomNumberB) {
        this.addBond(atomNumberA, atomNumberB, 1);
    }

    public void addMultipleSingleBonds(int i, int ... js) {
        int[] nArray = js;
        int n = js.length;
        int n2 = 0;
        while (n2 < n) {
            int j = nArray[n2];
            this.addSingleBond(i, j);
            ++n2;
        }
    }

    public void addBond(int atomNumberA, int atomNumberB, int order) {
        Atom a = this.atoms.get(atomNumberA);
        Atom b = this.atoms.get(atomNumberB);
        this.bonds.add(new Bond(a, b, order));
    }

    public boolean identical(Molecule other) {
        if (this.getBondCount() != other.getBondCount()) {
            return false;
        }
        for (Bond bond : this.bonds) {
            if (other.bonds.contains(bond)) continue;
            return false;
        }
        return true;
    }

    public boolean bondsOrdered() {
        int i = 1;
        while (i < this.bonds.size()) {
            Bond bondA = this.bonds.get(i - 1);
            Bond bondB = this.bonds.get(i);
            int aMin = Math.min(bondA.a.index, bondA.b.index);
            int aMax = Math.max(bondA.a.index, bondA.b.index);
            int bMin = Math.min(bondB.a.index, bondB.b.index);
            int bMax = Math.max(bondB.a.index, bondB.b.index);
            if (aMin >= bMin && (aMin != bMin || aMax >= bMax)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toEdgeString() {
        StringBuffer edgeString = new StringBuffer();
        ArrayList<Bond> listCopy = new ArrayList<Bond>();
        for (Bond bond : this.bonds) {
            listCopy.add(new Bond(bond));
        }
        Collections.sort(listCopy);
        for (Bond bond : listCopy) {
            if (bond.a.index < bond.b.index) {
                edgeString.append(bond.a).append(":").append(bond.b);
            } else {
                edgeString.append(bond.b).append(":").append(bond.a);
            }
            edgeString.append(",");
        }
        return edgeString.toString();
    }

    public int getFirstInBond(int bondIndex) {
        return this.bonds.get((int)bondIndex).a.index;
    }

    public int getSecondInBond(int bondIndex) {
        return this.bonds.get((int)bondIndex).b.index;
    }

    public int getBondOrder(int bondIndex) {
        return this.bonds.get((int)bondIndex).order;
    }

    public class Atom {
        public int index;
        public String symbol;

        public Atom(int index, String symbol) {
            this.index = index;
            this.symbol = symbol;
        }

        public Atom(Atom other) {
            this.index = other.index;
            this.symbol = other.symbol;
        }

        public boolean equals(Atom other) {
            return this.index == other.index && this.symbol.equals(other.symbol);
        }

        public String toString() {
            return String.valueOf(this.index) + this.symbol;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Bond
    implements Comparable<Bond> {
        public Atom a;
        public Atom b;
        public int order;

        public Bond(Atom a, Atom b, int order) {
            this.a = a;
            this.b = b;
            this.order = order;
        }

        public Bond(Bond other) {
            this.a = new Atom(other.a);
            this.b = new Atom(other.b);
            this.order = other.order;
        }

        public int getConnected(int i) {
            if (this.a.index == i) {
                return this.b.index;
            }
            if (this.b.index == i) {
                return this.a.index;
            }
            return -1;
        }

        public boolean equals(Object o) {
            Bond other = (Bond)o;
            return this.a.equals(other.a) && this.b.equals(other.b) || this.a.equals(other.b) && this.b.equals(other.a);
        }

        public boolean hasBoth(int atomIndexA, int atomIndexB) {
            return this.a.index == atomIndexA && this.b.index == atomIndexB || this.b.index == atomIndexA && this.a.index == atomIndexB;
        }

        public String toString() {
            if (this.a.index < this.b.index) {
                return this.a + "-" + this.b + "(" + this.order + ")";
            }
            return this.b + "-" + this.a + "(" + this.order + ")";
        }

        @Override
        public int compareTo(Bond o) {
            int thisMin = Math.min(this.a.index, this.b.index);
            int thisMax = Math.max(this.a.index, this.b.index);
            int oMin = Math.min(o.a.index, o.b.index);
            int oMax = Math.max(o.a.index, o.b.index);
            if (thisMin < oMin) {
                return -1;
            }
            if (thisMin == oMin) {
                if (thisMax < oMax) {
                    return -1;
                }
                if (thisMax == oMax) {
                    return 0;
                }
                return 1;
            }
            return 1;
        }
    }
}

