/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.Mol2Format;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.io.Mol2ReaderTest")
public class Mol2Reader
extends DefaultChemObjectReader {
    boolean firstLineisMolecule = false;
    BufferedReader input = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(Mol2Reader.class);

    public Mol2Reader(Reader in) {
        this.input = new BufferedReader(in);
    }

    public Mol2Reader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public Mol2Reader() {
        this(new StringReader(""));
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return Mol2Format.getInstance();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (IChemModel.class.equals(anInterface)) {
                return true;
            }
            if (IChemFile.class.equals(anInterface)) {
                return true;
            }
            if (!IMolecule.class.equals(anInterface)) continue;
            return true;
        }
        Class superClass = classObject.getSuperclass();
        return superClass != null && this.accepts(superClass);
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        if (object instanceof IChemModel) {
            return (T)this.readChemModel((IChemModel)object);
        }
        if (object instanceof IMolecule) {
            return (T)this.readMolecule((IMolecule)object);
        }
        throw new CDKException("Only supported are ChemFile and Molecule.");
    }

    private IChemModel readChemModel(IChemModel chemModel) throws CDKException {
        IMolecule m;
        IAtomContainerSet setOfMolecules = chemModel.getMoleculeSet();
        if (setOfMolecules == null) {
            setOfMolecules = chemModel.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
        }
        if ((m = this.readMolecule(chemModel.getBuilder().newInstance(IMolecule.class, new Object[0]))) != null) {
            setOfMolecules.addAtomContainer(m);
        }
        chemModel.setMoleculeSet(setOfMolecules);
        return chemModel;
    }

    private IChemFile readChemFile(IChemFile chemFile) throws CDKException {
        IChemSequence chemSequence = chemFile.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel chemModel = chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        IMoleculeSet setOfMolecules = chemFile.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
        IMolecule m = this.readMolecule(chemFile.getBuilder().newInstance(IMolecule.class, new Object[0]));
        if (m != null) {
            setOfMolecules.addMolecule(m);
        }
        chemModel.setMoleculeSet(setOfMolecules);
        chemSequence.addChemModel(chemModel);
        setOfMolecules = chemFile.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
        chemModel = chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        try {
            this.firstLineisMolecule = true;
            while (m != null) {
                m = this.readMolecule(chemFile.getBuilder().newInstance(IMolecule.class, new Object[0]));
                if (m == null) continue;
                setOfMolecules.addMolecule(m);
                chemModel.setMoleculeSet(setOfMolecules);
                chemSequence.addChemModel(chemModel);
                setOfMolecules = chemFile.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
                chemModel = chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
            }
        }
        catch (CDKException cdkexc) {
            throw cdkexc;
        }
        catch (Exception exception) {
            String error = "Error while parsing MOL2";
            logger.error(error);
            logger.debug(exception);
            throw new CDKException(error, exception);
        }
        try {
            this.input.close();
        }
        catch (Exception exc) {
            String error = "Error while closing file: " + exc.getMessage();
            logger.error(error);
            throw new CDKException(error, exc);
        }
        chemFile.addChemSequence(chemSequence);
        this.firstLineisMolecule = false;
        return chemFile;
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(IChemObject object) {
        if (object instanceof IChemFile) {
            return true;
        }
        if (object instanceof IChemModel) {
            return true;
        }
        return object instanceof IMolecule;
    }

    private IMolecule readMolecule(IMolecule molecule) throws CDKException {
        AtomTypeFactory atFactory = null;
        try {
            atFactory = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/mol2_atomtypes.xml", molecule.getBuilder());
        }
        catch (Exception exception) {
            String error = "Could not instantiate an AtomTypeFactory";
            logger.error(error);
            logger.debug(exception);
            throw new CDKException(error, exception);
        }
        try {
            String line;
            int atomCount = 0;
            int bondCount = 0;
            do {
                if ((line = this.input.readLine()) != null) continue;
                return null;
            } while (!line.startsWith("@<TRIPOS>MOLECULE") && (line.startsWith("#") || line.trim().length() <= 0));
            if (this.firstLineisMolecule) {
                molecule.setProperty("cdk:Title", line);
            } else {
                line = this.input.readLine();
                molecule.setProperty("cdk:Title", line);
            }
            String counts = this.input.readLine();
            StringTokenizer tokenizer = new StringTokenizer(counts);
            try {
                atomCount = Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException nfExc) {
                String error = "Error while reading atom count from MOLECULE block";
                logger.error(error);
                logger.debug(nfExc);
                throw new CDKException(error, nfExc);
            }
            if (tokenizer.hasMoreTokens()) {
                try {
                    bondCount = Integer.parseInt(tokenizer.nextToken());
                }
                catch (NumberFormatException nfExc) {
                    String error = "Error while reading atom and bond counts";
                    logger.error(error);
                    logger.debug(nfExc);
                    throw new CDKException(error, nfExc);
                }
            } else {
                bondCount = 0;
            }
            logger.info("Reading #atoms: ", atomCount);
            logger.info("Reading #bonds: ", bondCount);
            logger.warn("Not reading molecule qualifiers");
            line = this.input.readLine();
            boolean molend = false;
            while (line != null) {
                int i;
                if (line.startsWith("@<TRIPOS>MOLECULE")) {
                    molend = true;
                    break;
                }
                if (line.startsWith("@<TRIPOS>ATOM")) {
                    logger.info("Reading atom block");
                    for (i = 0; i < atomCount; ++i) {
                        IAtomType atomType;
                        line = this.input.readLine().trim();
                        if (line.startsWith("@<TRIPOS>MOLECULE")) {
                            molend = true;
                            break;
                        }
                        tokenizer = new StringTokenizer(line);
                        tokenizer.nextToken();
                        String nameStr = tokenizer.nextToken();
                        String xStr = tokenizer.nextToken();
                        String yStr = tokenizer.nextToken();
                        String zStr = tokenizer.nextToken();
                        String atomTypeStr = tokenizer.nextToken();
                        if ("S.o2".equals(atomTypeStr)) {
                            atomTypeStr = "S.O2";
                        }
                        if ("S.o".equals(atomTypeStr)) {
                            atomTypeStr = "S.O";
                        }
                        IAtom atom = molecule.getBuilder().newInstance(IAtom.class, "X");
                        try {
                            atomType = atFactory.getAtomType(atomTypeStr);
                        }
                        catch (Exception exception) {
                            atomType = null;
                        }
                        if (atomType == null && this.isElementSymbol(atomTypeStr)) {
                            atom.setSymbol(atomTypeStr);
                        } else {
                            if (atomType == null) {
                                atomType = atFactory.getAtomType("X");
                                logger.error("Could not find specified atom type: ", atomTypeStr);
                            }
                            AtomTypeManipulator.configure(atom, atomType);
                        }
                        atom.setID(nameStr);
                        atom.setAtomTypeName(atomTypeStr);
                        try {
                            double x = Double.parseDouble(xStr);
                            double y = Double.parseDouble(yStr);
                            double z = Double.parseDouble(zStr);
                            atom.setPoint3d(new Point3d(x, y, z));
                        }
                        catch (NumberFormatException nfExc) {
                            String error = "Error while reading atom coordinates";
                            logger.error(error);
                            logger.debug(nfExc);
                            throw new CDKException(error, nfExc);
                        }
                        molecule.addAtom(atom);
                    }
                } else if (line.startsWith("@<TRIPOS>BOND")) {
                    logger.info("Reading bond block");
                    for (i = 0; i < bondCount; ++i) {
                        line = this.input.readLine();
                        if (line.startsWith("@<TRIPOS>MOLECULE")) {
                            molend = true;
                            break;
                        }
                        tokenizer = new StringTokenizer(line);
                        tokenizer.nextToken();
                        String atom1Str = tokenizer.nextToken();
                        String atom2Str = tokenizer.nextToken();
                        String orderStr = tokenizer.nextToken();
                        try {
                            int atom1 = Integer.parseInt(atom1Str);
                            int atom2 = Integer.parseInt(atom2Str);
                            if ("nc".equals(orderStr)) continue;
                            IBond bond = molecule.getBuilder().newInstance(IBond.class, molecule.getAtom(atom1 - 1), molecule.getAtom(atom2 - 1));
                            if ("1".equals(orderStr)) {
                                bond.setOrder(CDKConstants.BONDORDER_SINGLE);
                            } else if ("2".equals(orderStr)) {
                                bond.setOrder(CDKConstants.BONDORDER_DOUBLE);
                            } else if ("3".equals(orderStr)) {
                                bond.setOrder(CDKConstants.BONDORDER_TRIPLE);
                            } else if ("am".equals(orderStr) || "ar".equals(orderStr)) {
                                bond.setOrder(CDKConstants.BONDORDER_SINGLE);
                                bond.setFlag(5, true);
                                bond.getAtom(0).setFlag(5, true);
                                bond.getAtom(1).setFlag(5, true);
                            } else if ("du".equals(orderStr)) {
                                bond.setOrder(CDKConstants.BONDORDER_SINGLE);
                            } else if ("un".equals(orderStr)) {
                                bond.setOrder(CDKConstants.BONDORDER_SINGLE);
                            }
                            molecule.addBond(bond);
                            continue;
                        }
                        catch (NumberFormatException nfExc) {
                            String error = "Error while reading bond information";
                            logger.error(error);
                            logger.debug(nfExc);
                            throw new CDKException(error, nfExc);
                        }
                    }
                }
                if (molend) {
                    return molecule;
                }
                line = this.input.readLine();
            }
        }
        catch (IOException exception) {
            String error = "Error while reading general structure";
            logger.error(error);
            logger.debug(exception);
            throw new CDKException(error, exception);
        }
        return molecule;
    }

    private boolean isElementSymbol(String atomTypeStr) {
        for (int i = 1; i < PeriodicTable.getElementCount(); ++i) {
            if (!PeriodicTable.getSymbol(i).equals(atomTypeStr)) continue;
            return true;
        }
        return false;
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }
}

