/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.KappaShapeIndicesDescriptorTest")
public class KappaShapeIndicesDescriptor
implements IMolecularDescriptor {
    private static final String[] names = new String[]{"Kier1", "Kier2", "Kier3"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#kierValues", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer container) {
        double kier3;
        double kier2;
        double kier1;
        IAtomContainer atomContainer;
        try {
            atomContainer = (IAtomContainer)container.clone();
        }
        catch (CloneNotSupportedException e) {
            DoubleArrayResult kierValues = new DoubleArrayResult(3);
            kierValues.add(Double.NaN);
            kierValues.add(Double.NaN);
            kierValues.add(Double.NaN);
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), kierValues, this.getDescriptorNames());
        }
        atomContainer = AtomContainerManipulator.removeHydrogens(atomContainer);
        DoubleArrayResult kierValues = new DoubleArrayResult(3);
        double atomsCount = atomContainer.getAtomCount();
        ArrayList<Double> singlePaths = new ArrayList<Double>();
        ArrayList<String> doublePaths = new ArrayList<String>();
        ArrayList<String> triplePaths = new ArrayList<String>();
        double[] sorterFirst = new double[2];
        double[] sorterSecond = new double[3];
        int a1 = 0;
        while ((double)a1 < atomsCount) {
            double bond1 = 0.0;
            List<IAtom> firstAtomNeighboors = atomContainer.getConnectedAtomsList(atomContainer.getAtom(a1));
            for (int a2 = 0; a2 < firstAtomNeighboors.size(); ++a2) {
                bond1 = atomContainer.getBondNumber(atomContainer.getAtom(a1), firstAtomNeighboors.get(a2));
                if (!singlePaths.contains(new Double(bond1))) {
                    singlePaths.add(bond1);
                    Collections.sort(singlePaths);
                }
                List<IAtom> secondAtomNeighboors = atomContainer.getConnectedAtomsList(firstAtomNeighboors.get(a2));
                for (int a3 = 0; a3 < secondAtomNeighboors.size(); ++a3) {
                    double bond2 = atomContainer.getBondNumber(firstAtomNeighboors.get(a2), secondAtomNeighboors.get(a3));
                    if (!singlePaths.contains(new Double(bond2))) {
                        singlePaths.add(bond2);
                    }
                    sorterFirst[0] = bond1;
                    sorterFirst[1] = bond2;
                    Arrays.sort(sorterFirst);
                    String tmpbond2 = sorterFirst[0] + "+" + sorterFirst[1];
                    if (!doublePaths.contains(tmpbond2) && bond1 != bond2) {
                        doublePaths.add(tmpbond2);
                    }
                    List<IAtom> thirdAtomNeighboors = atomContainer.getConnectedAtomsList(secondAtomNeighboors.get(a3));
                    for (int a4 = 0; a4 < thirdAtomNeighboors.size(); ++a4) {
                        double bond3 = atomContainer.getBondNumber(secondAtomNeighboors.get(a3), thirdAtomNeighboors.get(a4));
                        if (!singlePaths.contains(new Double(bond3))) {
                            singlePaths.add(bond3);
                        }
                        sorterSecond[0] = bond1;
                        sorterSecond[1] = bond2;
                        sorterSecond[2] = bond3;
                        Arrays.sort(sorterSecond);
                        String tmpbond3 = sorterSecond[0] + "+" + sorterSecond[1] + "+" + sorterSecond[2];
                        if (triplePaths.contains(tmpbond3) || bond1 == bond2 || bond1 == bond3 || bond2 == bond3) continue;
                        triplePaths.add(tmpbond3);
                    }
                }
            }
            ++a1;
        }
        if (atomsCount == 1.0) {
            kier1 = 0.0;
            kier2 = 0.0;
            kier3 = 0.0;
        } else {
            kier1 = atomsCount * ((atomsCount - 1.0) * (atomsCount - 1.0)) / (double)(singlePaths.size() * singlePaths.size());
            if (atomsCount == 2.0) {
                kier2 = 0.0;
                kier3 = 0.0;
            } else {
                kier2 = doublePaths.size() == 0 ? Double.NaN : (atomsCount - 1.0) * ((atomsCount - 2.0) * (atomsCount - 2.0)) / (double)(doublePaths.size() * doublePaths.size());
                kier3 = atomsCount == 3.0 ? 0.0 : (atomsCount % 2.0 != 0.0 ? (triplePaths.size() == 0 ? Double.NaN : (atomsCount - 1.0) * ((atomsCount - 3.0) * (atomsCount - 3.0)) / (double)(triplePaths.size() * triplePaths.size())) : (triplePaths.size() == 0 ? Double.NaN : (atomsCount - 3.0) * ((atomsCount - 2.0) * (atomsCount - 2.0)) / (double)(triplePaths.size() * triplePaths.size())));
            }
        }
        kierValues.add(kier1);
        kierValues.add(kier2);
        kierValues.add(kier3);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), kierValues, this.getDescriptorNames());
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(3);
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }
}

