/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Element;
import nu.xom.Node;
import org.xmlcml.cml.base.AbstractGenerator;
import org.xmlcml.cml.base.CMLAttribute;
import org.xmlcml.cml.base.CMLElementType;
import org.xmlcml.cml.base.CMLType;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.base.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementGenerator
extends AbstractGenerator {
    private Map<String, CMLElementType> elementTypeMap;

    public ElementGenerator(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.init();
    }

    private void init() {
        this.elementTypeMap = new HashMap<String, CMLElementType>();
        this.nameList = new ArrayList();
    }

    public void readAssembleAndIndexElementSchema(String indir) throws Exception {
        this.readAndAssembleSchemaComponents(indir);
        this.indexSchema();
    }

    public void indexSchema() {
        List<Node> xsdElements = CMLUtil.getQueryNodes(this.schema, "./xsd:element", XPATH_XSD);
        for (Node node : xsdElements) {
            Element xsdElement = (Element)node;
            String name = xsdElement.getAttributeValue("name");
            CMLElementType elementType = null;
            if (name == null) {
                System.err.println("No name element on element");
            } else {
                elementType = new CMLElementType(xsdElement);
                this.elementTypeMap.put(name, elementType);
                this.nameList.add(name);
            }
            Map<String, CMLAttribute> attributeGroupMap = this.schemaManager.getAttributeGenerator().getAttributeGroupMap();
            elementType.processAttributes(attributeGroupMap);
            Map<String, CMLType> typeMap = this.schemaManager.getTypeGenerator().getMap();
            elementType.processSimpleContent(typeMap);
        }
        for (String name : this.nameList) {
            CMLElementType elementType = this.elementTypeMap.get(name);
            elementType.processComplexContent(this.elementTypeMap);
        }
    }

    void printElements() {
        for (String name : this.nameList) {
            CMLElementType elementType = this.elementTypeMap.get(name);
            System.out.println("========================================");
            System.out.println(name);
            System.out.println("========================================");
            System.out.println(elementType.toString());
        }
    }

    public Map<String, CMLElementType> getElementTypeMap() {
        return this.elementTypeMap;
    }

    public void setElementTypeMap(Map<String, CMLElementType> elementTypeMap) {
        this.elementTypeMap = elementTypeMap;
    }

    public List<String> getNameList() {
        return this.nameList;
    }

    public void setNameList(List<String> nameList) {
        this.nameList = nameList;
    }
}

