/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.CMLReader;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.isomorphism.mcss.RMap;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;

@TestClass(value="org.openscience.cdk.layout.TemplateHandlerTest")
public class TemplateHandler {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(TemplateHandler.class);
    private List<IAtomContainer> templates = null;
    private UniversalIsomorphismTester universalIsomorphismTester = new UniversalIsomorphismTester();

    @TestMethod(value="testInit")
    public TemplateHandler(IChemObjectBuilder builder) {
        this.templates = new ArrayList<IAtomContainer>();
        this.loadTemplates(builder);
    }

    @TestMethod(value="testInit")
    public void loadTemplates(IChemObjectBuilder builder) {
        String line = null;
        try {
            InputStream ins = this.getClass().getClassLoader().getResourceAsStream("org/openscience/cdk/layout/templates/templates.list");
            BufferedReader reader = new BufferedReader(new InputStreamReader(ins));
            while (reader.ready()) {
                line = reader.readLine();
                line = "org/openscience/cdk/layout/templates/" + line;
                logger.debug("Attempting to read template ", line);
                try {
                    CMLReader structureReader = new CMLReader(this.getClass().getClassLoader().getResourceAsStream(line));
                    IChemFile file = (IChemFile)structureReader.read((IChemObject)builder.newInstance(IChemFile.class, new Object[0]));
                    List<IAtomContainer> files = ChemFileManipulator.getAllAtomContainers(file);
                    for (int i = 0; i < files.size(); ++i) {
                        this.templates.add(files.get(i));
                    }
                    logger.debug("Successfully read template ", line);
                }
                catch (CDKException cdke) {
                    logger.warn("Could not read template ", line, ", reason: ", cdke.getMessage());
                    logger.debug(cdke);
                }
                catch (IllegalArgumentException iae) {
                    logger.warn("Could not read template ", line, ", reason: ", iae.getMessage());
                    logger.debug(iae);
                }
            }
        }
        catch (IOException ioe) {
            logger.warn("Could not read (all of the) templates, reason: ", ioe.getMessage());
            logger.debug(ioe);
        }
    }

    @TestMethod(value="testAddMolecule")
    public void addMolecule(IAtomContainer molecule) {
        this.templates.add(molecule);
    }

    @TestMethod(value="testRemoveMolecule")
    public IAtomContainer removeMolecule(IAtomContainer molecule) throws CDKException {
        IAtomContainer ac1 = molecule.getBuilder().newInstance(IAtomContainer.class, molecule);
        IAtomContainer ac2 = null;
        IAtomContainer mol2 = null;
        for (int f = 0; f < this.templates.size(); ++f) {
            mol2 = this.templates.get(f);
            ac2 = molecule.getBuilder().newInstance(IAtomContainer.class, mol2);
            if (!new UniversalIsomorphismTester().isIsomorph(ac1, ac2)) continue;
            this.templates.remove(f);
            return mol2;
        }
        return null;
    }

    public boolean mapTemplateExact(IAtomContainer molecule) throws CDKException {
        logger.debug("Trying to map a molecule...");
        boolean mapped = false;
        IAtomContainer template = null;
        RMap map = null;
        IAtom atom1 = null;
        IAtom atom2 = null;
        for (int f = 0; f < this.templates.size(); ++f) {
            template = this.templates.get(f);
            if (new UniversalIsomorphismTester().isIsomorph(molecule, template)) {
                List<RMap> list = this.universalIsomorphismTester.getIsomorphAtomsMap(molecule.getBuilder().newInstance(IAtomContainer.class, molecule), molecule.getBuilder().newInstance(IAtomContainer.class, template));
                logger.debug("Found a subgraph mapping of size " + list.size() + ", template: " + template.getID());
                for (int i = 0; i < list.size(); ++i) {
                    map = list.get(i);
                    atom1 = molecule.getAtom(map.getId1());
                    atom2 = template.getAtom(map.getId2());
                    atom1.setPoint2d(new Point2d(atom2.getPoint2d()));
                    atom1.setFlag(1, true);
                }
                mapped = true;
                continue;
            }
            logger.debug("Structure does not match template: ", template.getID());
        }
        return mapped;
    }

    @TestMethod(value="testRemoveMolecule")
    public boolean mapTemplates(IAtomContainer molecule) throws CDKException {
        logger.debug("Trying to map a molecule...");
        boolean mapped = false;
        IAtomContainer template = null;
        RMap map = null;
        IAtom atom1 = null;
        IAtom atom2 = null;
        for (int f = 0; f < this.templates.size(); ++f) {
            template = this.templates.get(f);
            if (this.universalIsomorphismTester.isSubgraph(molecule, template)) {
                List<List<RMap>> listOfLists = this.universalIsomorphismTester.getSubgraphAtomsMaps(molecule.getBuilder().newInstance(IAtomContainer.class, molecule), molecule.getBuilder().newInstance(IAtomContainer.class, template));
                logger.debug("Found " + listOfLists.size() + " subgraphs matching template: " + template.getID());
                for (List<RMap> list : listOfLists) {
                    logger.debug("Found a subgraph mapping of size " + list.size() + ", template: " + template.getID());
                    for (int i = 0; i < list.size(); ++i) {
                        map = list.get(i);
                        atom1 = molecule.getAtom(map.getId1());
                        atom2 = template.getAtom(map.getId2());
                        atom1.setPoint2d(new Point2d(atom2.getPoint2d()));
                        atom1.setFlag(1, true);
                    }
                    mapped = true;
                }
                continue;
            }
            logger.debug("Structure does not match template: ", template.getID());
        }
        return mapped;
    }

    @TestMethod(value="testInit")
    public int getTemplateCount() {
        return this.templates.size();
    }

    public IAtomContainer getTemplateAt(int position) {
        return this.templates.get(position);
    }

    @TestMethod(value="getMappedSubstructures_IAtomContainer")
    public IAtomContainerSet getMappedSubstructures(IAtomContainer molecule) throws CDKException {
        logger.debug("Trying get mapped substructures...");
        IAtomContainerSet matchedSubstructures = molecule.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        for (int f = 0; f < this.templates.size(); ++f) {
            IAtomContainer template = this.templates.get(f);
            if (this.universalIsomorphismTester.isSubgraph(molecule, template)) {
                List<List<RMap>> listOfLists = this.universalIsomorphismTester.getSubgraphAtomsMaps(molecule.getBuilder().newInstance(IAtomContainer.class, molecule), molecule.getBuilder().newInstance(IAtomContainer.class, template));
                logger.debug("Found " + listOfLists.size() + " subgraphs matching template: " + template.getID());
                for (List<RMap> list : listOfLists) {
                    logger.debug("Found a subgraph mapping of size " + list.size() + ", template: " + template.getID());
                    IAtomContainer matchedSubstructure = molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                    for (RMap map : list) {
                        IAtom atom = molecule.getAtom(map.getId1());
                        matchedSubstructure.addAtom(atom);
                    }
                    for (IAtom atom : matchedSubstructure.atoms()) {
                        for (IBond bond : molecule.getConnectedBondsList(atom)) {
                            boolean addBond = true;
                            for (IAtom connectedAtom : bond.atoms()) {
                                if (matchedSubstructure.contains(connectedAtom) && !matchedSubstructure.contains(bond)) continue;
                                addBond = false;
                            }
                            if (!addBond) continue;
                            matchedSubstructure.addBond(bond);
                        }
                    }
                    matchedSubstructures.addAtomContainer(matchedSubstructure);
                }
                continue;
            }
            logger.debug("Structure does not match template: ", template.getID());
        }
        for (int i = 0; i < matchedSubstructures.getAtomContainerCount(); ++i) {
            for (int j = i + 1; j < matchedSubstructures.getAtomContainerCount(); ++j) {
                if (!this.haveSameAtoms(matchedSubstructures.getAtomContainer(i), matchedSubstructures.getAtomContainer(j))) continue;
                matchedSubstructures.removeAtomContainer(j--);
            }
        }
        logger.debug("Found " + matchedSubstructures.getAtomContainerCount() + " unique matched subgraphs");
        return matchedSubstructures;
    }

    private boolean haveSameAtoms(IAtomContainer atomContainer1, IAtomContainer atomContainer2) {
        if (atomContainer1.getAtomCount() != atomContainer2.getAtomCount()) {
            return false;
        }
        Iterator<IAtom> iterator = atomContainer1.atoms().iterator();
        while (iterator.hasNext()) {
            if (atomContainer2.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }
}

