/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.Locale;

class CECalendar
extends Calendar {
    private static final long serialVersionUID = -999547623066414271L;
    private static final int[][] LIMITS = new int[][]{{0, 0, 1, 1}, {1, 1, 5828963, 5838270}, {0, 0, 13, 13}, {1, 1, 52, 53}, {0, 0, 1, 6}, {1, 1, 5, 30}, {1, 1, 365, 366}, new int[0], {-1, -1, 4, 6}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {-5838270, -5838270, 5828964, 5838271}, new int[0], {-5838269, -5838269, 5828963, 5838270}, new int[0], new int[0]};
    private static final int[][] ceMONTH_COUNT = new int[][]{{30, 30, 0, 0}, {30, 30, 30, 30}, {30, 30, 60, 60}, {30, 30, 90, 90}, {30, 30, 120, 120}, {30, 30, 150, 150}, {30, 30, 180, 180}, {30, 30, 210, 210}, {30, 30, 240, 244}, {30, 30, 270, 270}, {30, 30, 300, 300}, {30, 30, 330, 330}, {5, 6, 360, 360}};
    protected int jdEpochOffset = -1;

    protected int handleGetLimit(int field, int limitType) {
        return LIMITS[field][limitType];
    }

    protected CECalendar() {
        this(TimeZone.getDefault(), ULocale.getDefault());
    }

    protected CECalendar(TimeZone zone) {
        this(zone, ULocale.getDefault());
    }

    protected CECalendar(Locale aLocale) {
        this(TimeZone.getDefault(), aLocale);
    }

    protected CECalendar(ULocale locale) {
        this(TimeZone.getDefault(), locale);
    }

    protected CECalendar(TimeZone zone, Locale aLocale) {
        super(zone, aLocale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    protected CECalendar(TimeZone zone, ULocale locale) {
        super(zone, locale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    protected CECalendar(int year, int month, int date) {
        super(TimeZone.getDefault(), ULocale.getDefault());
        this.set(year, month, date);
    }

    protected CECalendar(Date date) {
        super(TimeZone.getDefault(), ULocale.getDefault());
        this.setTime(date);
    }

    protected CECalendar(int year, int month, int date, int hour, int minute, int second) {
        super(TimeZone.getDefault(), ULocale.getDefault());
        this.set(year, month, date, hour, minute, second);
    }

    protected int handleComputeMonthStart(int eyear, int emonth, boolean useMonth) {
        return CECalendar.ceToJD(eyear, emonth, 0, this.jdEpochOffset);
    }

    protected int handleGetExtendedYear() {
        int year = this.newerField(19, 1) == 19 ? this.internalGet(19, 1) : this.internalGet(1, 1);
        return year;
    }

    protected void handleComputeFields(int julianDay) {
        Integer[] date = CECalendar.getDateFromJD(julianDay, this.jdEpochOffset);
        int _year = date[0];
        int _month = date[1];
        int _day = date[2];
        int ceyear = 0;
        int era = 1;
        if (_year < 0) {
            era = 0;
            ceyear = 1 - _year;
        } else {
            ceyear = _year;
        }
        this.internalSet(2, _month);
        this.internalSet(5, _day);
        this.internalSet(6, 30 * _month + _day);
        this.internalSet(19, ceyear);
        this.internalSet(0, era);
        this.internalSet(1, _year);
    }

    public static int ceToJD(long year, int month, int date, int jdEpochOffset) {
        return (int)((long)(jdEpochOffset + 365) + 365L * (year - 1L) + (long)CECalendar.quotient(year, 4) + (long)(30 * (month + 1)) + (long)date - 31L);
    }

    public static Integer[] getDateFromJD(int julianDay, int jdEpochOffset) {
        long r4 = CECalendar.mod(julianDay - jdEpochOffset, 1461);
        long n = CECalendar.mod(r4, 365) + 365 * CECalendar.quotient(r4, 1460);
        long aprime = 4 * CECalendar.quotient(julianDay - jdEpochOffset, 1461) + CECalendar.quotient(r4, 365) - CECalendar.quotient(r4, 1460) - 1;
        int _year = (int)(aprime + 1L);
        int _month = CECalendar.quotient(n, 30);
        int _day = CECalendar.mod(n, 30) + 1;
        return new Integer[]{new Integer(_year), new Integer(_month), new Integer(_day)};
    }

    static int mod(long i, int j) {
        return (int)(i - (long)j * (long)CECalendar.quotient(i, j));
    }

    static int quotient(long i, int j) {
        return (int)Math.floor((double)i / (double)j);
    }
}

