/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.ArrayList;
import nu.xom.Attribute;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.IllegalAddException;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.URIUtil;
import nu.xom.WellformednessException;
import nu.xom.XMLException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

class XOMHandler
implements ContentHandler,
LexicalHandler,
DeclHandler,
DTDHandler {
    protected Document document;
    protected String documentBaseURI;
    protected ParentNode parent;
    protected ParentNode current;
    protected ArrayList parents;
    protected boolean inProlog;
    protected boolean inDTD;
    protected int position;
    protected Locator locator;
    protected DocType doctype;
    protected StringBuffer internalDTDSubset;
    protected NodeFactory factory;
    boolean usingCrimson = false;
    protected String textString = null;
    protected StringBuffer buffer = null;
    protected boolean inExternalSubset = false;
    protected boolean inCDATA = false;
    protected boolean finishedCDATA = false;

    XOMHandler(NodeFactory factory) {
        this.factory = factory;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    Document getDocument() {
        return this.document;
    }

    void freeMemory() {
        this.document = null;
        this.parent = null;
        this.current = null;
        this.parents = null;
        this.locator = null;
        this.doctype = null;
        this.internalDTDSubset = null;
    }

    public void startDocument() {
        this.inDTD = false;
        this.document = this.factory.startMakingDocument();
        this.parent = this.document;
        this.current = this.document;
        this.parents = new ArrayList();
        this.parents.add(this.document);
        this.inProlog = true;
        this.position = 0;
        this.textString = null;
        this.doctype = null;
        if (this.locator != null) {
            this.documentBaseURI = this.locator.getSystemId();
            this.document.setBaseURI(this.documentBaseURI);
        }
        this.buffer = null;
    }

    public void endDocument() {
        this.factory.finishMakingDocument(this.document);
        this.parents.remove(this.parents.size() - 1);
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) {
        Element element;
        this.flushText();
        if (this.parent != this.document) {
            element = this.factory.startMakingElement(qualifiedName, namespaceURI);
        } else {
            element = this.factory.makeRootElement(qualifiedName, namespaceURI);
            if (element == null) {
                throw new NullPointerException("Factory failed to create root element.");
            }
            this.document.setRootElement(element);
            this.inProlog = false;
        }
        this.current = element;
        this.parents.add(element);
        if (element != null) {
            String qName;
            int i;
            String baseURI;
            if (this.parent != this.document) {
                this.parent.appendChild(element);
            }
            if (this.locator != null && (baseURI = this.locator.getSystemId()) != null && !baseURI.equals(this.documentBaseURI)) {
                element.setActualBaseURI(baseURI);
            }
            for (i = 0; i < attributes.getLength(); ++i) {
                qName = attributes.getQName(i);
                if (qName.startsWith("xmlns:") || qName.equals("xmlns")) continue;
                String namespace = attributes.getURI(i);
                String value = attributes.getValue(i);
                Nodes nodes = this.factory.makeAttribute(qName, namespace, value, XOMHandler.convertStringToType(attributes.getType(i)));
                int numberChildren = 0;
                for (int j = 0; j < nodes.size(); ++j) {
                    Node node = nodes.get(j);
                    if (node.isAttribute()) {
                        this.factory.addAttribute(element, (Attribute)node);
                        continue;
                    }
                    this.factory.insertChild(element, node, numberChildren++);
                }
            }
            for (i = 0; i < attributes.getLength(); ++i) {
                String namespacePrefix;
                String currentValue;
                String namespaceName;
                qName = attributes.getQName(i);
                if (qName.startsWith("xmlns:")) {
                    namespaceName = attributes.getValue(i);
                    if (namespaceName.equals(currentValue = element.getNamespaceURI(namespacePrefix = qName.substring(6))) || namespacePrefix.equals(element.getNamespacePrefix())) continue;
                    element.addNamespaceDeclaration(namespacePrefix, namespaceName);
                    continue;
                }
                if (!qName.equals("xmlns") || (namespaceName = attributes.getValue(i)).equals(currentValue = element.getNamespaceURI(namespacePrefix = "")) || "".equals(element.getNamespacePrefix())) continue;
                element.addNamespaceDeclaration(namespacePrefix, namespaceName);
            }
            this.parent = element;
        }
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) {
        this.current = (ParentNode)this.parents.remove(this.parents.size() - 1);
        this.flushText();
        if (this.current != null) {
            this.parent = this.current.getParent();
            Nodes result = this.factory.finishMakingElement((Element)this.current);
            if (result.size() != 1 || result.get(0) != this.current) {
                if (!this.parent.isDocument()) {
                    int childCount = this.parent.getChildCount();
                    try {
                        this.parent.removeChild(childCount - 1);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new XMLException("Factory detached element in finishMakingElement()", ex);
                    }
                    for (int i = 0; i < result.size(); ++i) {
                        Node node = result.get(i);
                        if (node.isAttribute()) {
                            ((Element)this.parent).addAttribute((Attribute)node);
                            continue;
                        }
                        this.parent.appendChild(node);
                    }
                } else {
                    Document doc = (Document)this.parent;
                    Element currentRoot = doc.getRootElement();
                    boolean beforeRoot = true;
                    for (int i = 0; i < result.size(); ++i) {
                        Node node = result.get(i);
                        if (node.isElement()) {
                            if (node != currentRoot) {
                                if (!beforeRoot) {
                                    throw new IllegalAddException("Factory returned multiple roots");
                                }
                                doc.setRootElement((Element)node);
                            }
                            beforeRoot = false;
                            continue;
                        }
                        if (beforeRoot) {
                            doc.insertChild(node, doc.indexOf(doc.getRootElement()));
                            continue;
                        }
                        doc.appendChild(node);
                    }
                    if (beforeRoot) {
                        throw new WellformednessException("Factory attempted to remove the root element");
                    }
                }
            }
        }
    }

    static Attribute.Type convertStringToType(String saxType) {
        if (saxType.equals("CDATA")) {
            return Attribute.Type.CDATA;
        }
        if (saxType.equals("ID")) {
            return Attribute.Type.ID;
        }
        if (saxType.equals("IDREF")) {
            return Attribute.Type.IDREF;
        }
        if (saxType.equals("IDREFS")) {
            return Attribute.Type.IDREFS;
        }
        if (saxType.equals("NMTOKEN")) {
            return Attribute.Type.NMTOKEN;
        }
        if (saxType.equals("NMTOKENS")) {
            return Attribute.Type.NMTOKENS;
        }
        if (saxType.equals("ENTITY")) {
            return Attribute.Type.ENTITY;
        }
        if (saxType.equals("ENTITIES")) {
            return Attribute.Type.ENTITIES;
        }
        if (saxType.equals("NOTATION")) {
            return Attribute.Type.NOTATION;
        }
        if (saxType.equals("ENUMERATION")) {
            return Attribute.Type.ENUMERATION;
        }
        if (saxType.startsWith("(")) {
            return Attribute.Type.ENUMERATION;
        }
        return Attribute.Type.UNDECLARED;
    }

    public void characters(char[] text, int start, int length) {
        if (length <= 0) {
            return;
        }
        if (this.textString == null) {
            this.textString = new String(text, start, length);
        } else {
            if (this.buffer == null) {
                this.buffer = new StringBuffer(this.textString);
            }
            this.buffer.append(text, start, length);
        }
        if (this.finishedCDATA) {
            this.inCDATA = false;
        }
    }

    protected void flushText() {
        if (this.buffer != null) {
            this.textString = this.buffer.toString();
            this.buffer = null;
        }
        if (this.textString != null) {
            Nodes result = !this.inCDATA ? this.factory.makeText(this.textString) : this.factory.makeCDATASection(this.textString);
            for (int i = 0; i < result.size(); ++i) {
                Node node = result.get(i);
                if (node.isAttribute()) {
                    ((Element)this.parent).addAttribute((Attribute)node);
                    continue;
                }
                this.parent.appendChild(node);
            }
            this.textString = null;
        }
        this.inCDATA = false;
        this.finishedCDATA = false;
    }

    public void ignorableWhitespace(char[] text, int start, int length) {
        this.characters(text, start, length);
    }

    public void processingInstruction(String target, String data) {
        if (!this.inDTD) {
            this.flushText();
        }
        if (this.inDTD && !this.inInternalSubset()) {
            return;
        }
        Nodes result = this.factory.makeProcessingInstruction(target, data);
        for (int i = 0; i < result.size(); ++i) {
            Node node = result.get(i);
            if (!this.inDTD) {
                if (this.inProlog) {
                    this.parent.insertChild(node, this.position);
                    ++this.position;
                    continue;
                }
                if (node.isAttribute()) {
                    ((Element)this.parent).addAttribute((Attribute)node);
                    continue;
                }
                this.parent.appendChild(node);
                continue;
            }
            if (node.isProcessingInstruction() || node.isComment()) {
                this.internalDTDSubset.append("  ");
                this.internalDTDSubset.append(node.toXML());
                this.internalDTDSubset.append("\n");
                continue;
            }
            throw new XMLException("Factory tried to put a " + node.getClass().getName() + " in the internal DTD subset");
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
    }

    public void endPrefixMapping(String prefix) {
    }

    public void skippedEntity(String name) {
        if (name.startsWith("%")) {
            return;
        }
        this.flushText();
        throw new XMLException("Could not resolve entity " + name);
    }

    public void startDTD(String rootName, String publicID, String systemID) {
        this.inDTD = true;
        Nodes result = this.factory.makeDocType(rootName, publicID, systemID);
        for (int i = 0; i < result.size(); ++i) {
            Node node = result.get(i);
            this.document.insertChild(node, this.position);
            ++this.position;
            if (!node.isDocType()) continue;
            DocType doctype = (DocType)node;
            this.internalDTDSubset = new StringBuffer();
            this.doctype = doctype;
        }
    }

    public void endDTD() {
        this.inDTD = false;
        if (this.doctype != null) {
            this.doctype.fastSetInternalDTDSubset(this.internalDTDSubset.toString());
        }
    }

    public void startEntity(String name) {
        if (name.equals("[dtd]")) {
            this.inExternalSubset = true;
        }
    }

    public void endEntity(String name) {
        if (name.equals("[dtd]")) {
            this.inExternalSubset = false;
        }
    }

    public void startCDATA() {
        if (this.textString == null) {
            this.inCDATA = true;
        }
        this.finishedCDATA = false;
    }

    public void endCDATA() {
        this.finishedCDATA = true;
    }

    public void comment(char[] text, int start, int length) {
        if (!this.inDTD) {
            this.flushText();
        }
        if (this.inDTD && !this.inInternalSubset()) {
            return;
        }
        Nodes result = this.factory.makeComment(new String(text, start, length));
        for (int i = 0; i < result.size(); ++i) {
            Node node = result.get(i);
            if (!this.inDTD) {
                if (this.inProlog) {
                    this.parent.insertChild(node, this.position);
                    ++this.position;
                    continue;
                }
                if (node instanceof Attribute) {
                    ((Element)this.parent).addAttribute((Attribute)node);
                    continue;
                }
                this.parent.appendChild(node);
                continue;
            }
            if (node.isComment() || node.isProcessingInstruction()) {
                this.internalDTDSubset.append("  ");
                this.internalDTDSubset.append(node.toXML());
                this.internalDTDSubset.append("\n");
                continue;
            }
            throw new XMLException("Factory tried to put a " + node.getClass().getName() + " in the internal DTD subset");
        }
    }

    public void elementDecl(String name, String model) {
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!ELEMENT ");
            this.internalDTDSubset.append(name);
            this.internalDTDSubset.append(' ');
            this.internalDTDSubset.append(model);
            if (model.indexOf("#PCDATA") > 0 && model.indexOf(124) > 0 && model.endsWith(")")) {
                this.internalDTDSubset.append('*');
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    protected boolean inInternalSubset() {
        if (!this.usingCrimson && !this.inExternalSubset) {
            return true;
        }
        String currentURI = this.locator.getSystemId();
        if (currentURI == this.documentBaseURI) {
            return true;
        }
        return currentURI.equals(this.documentBaseURI);
    }

    public void attributeDecl(String elementName, String attributeName, String type, String mode, String defaultValue) {
        if (type.startsWith("NOTATION ") && type.indexOf(40) == -1 && !type.endsWith(")")) {
            type = "NOTATION (" + type.substring("NOTATION ".length()) + ")";
        }
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!ATTLIST ");
            this.internalDTDSubset.append(elementName);
            this.internalDTDSubset.append(' ');
            this.internalDTDSubset.append(attributeName);
            this.internalDTDSubset.append(' ');
            this.internalDTDSubset.append(type);
            if (mode != null) {
                this.internalDTDSubset.append(' ');
                this.internalDTDSubset.append(mode);
            }
            if (defaultValue != null) {
                this.internalDTDSubset.append(' ');
                this.internalDTDSubset.append('\"');
                this.internalDTDSubset.append(XOMHandler.escapeReservedCharactersInDefaultAttributeValues(defaultValue));
                this.internalDTDSubset.append("\"");
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    public void internalEntityDecl(String name, String value) {
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!ENTITY ");
            if (name.startsWith("%")) {
                this.internalDTDSubset.append("% ");
                this.internalDTDSubset.append(name.substring(1));
            } else {
                this.internalDTDSubset.append(name);
            }
            this.internalDTDSubset.append(" \"");
            this.internalDTDSubset.append(XOMHandler.escapeReservedCharactersInDeclarations(value));
            this.internalDTDSubset.append("\">\n");
        }
    }

    public void externalEntityDecl(String name, String publicID, String systemID) {
        if (this.inInternalSubset() && this.doctype != null) {
            String documentURL;
            this.internalDTDSubset.append("  <!ENTITY ");
            if (name.startsWith("%")) {
                this.internalDTDSubset.append("% ");
                this.internalDTDSubset.append(name.substring(1));
            } else {
                this.internalDTDSubset.append(name);
            }
            if (this.locator != null && URIUtil.isAbsolute(systemID) && (documentURL = this.locator.getSystemId()) != null) {
                if (documentURL.startsWith("file:/") && !documentURL.startsWith("file:///")) {
                    documentURL = "file://" + documentURL.substring(5);
                }
                if (systemID.startsWith("file:/") && !systemID.startsWith("file:///")) {
                    systemID = "file://" + systemID.substring(5);
                }
                systemID = URIUtil.relativize(documentURL, systemID);
            }
            if (publicID != null) {
                this.internalDTDSubset.append(" PUBLIC \"");
                this.internalDTDSubset.append(publicID);
                this.internalDTDSubset.append("\" \"");
                this.internalDTDSubset.append(systemID);
            } else {
                this.internalDTDSubset.append(" SYSTEM \"");
                this.internalDTDSubset.append(systemID);
            }
            this.internalDTDSubset.append("\">\n");
        }
    }

    public void notationDecl(String name, String publicID, String systemID) {
        if (systemID != null) {
            systemID = XOMHandler.escapeReservedCharactersInDeclarations(systemID);
        }
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!NOTATION ");
            this.internalDTDSubset.append(name);
            if (publicID != null) {
                this.internalDTDSubset.append(" PUBLIC \"");
                this.internalDTDSubset.append(publicID);
                this.internalDTDSubset.append('\"');
                if (systemID != null) {
                    this.internalDTDSubset.append(" \"");
                    this.internalDTDSubset.append(systemID);
                    this.internalDTDSubset.append('\"');
                }
            } else {
                this.internalDTDSubset.append(" SYSTEM \"");
                this.internalDTDSubset.append(systemID);
                this.internalDTDSubset.append('\"');
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    public void unparsedEntityDecl(String name, String publicID, String systemID, String notationName) {
        if (this.inInternalSubset() && this.doctype != null) {
            this.internalDTDSubset.append("  <!ENTITY ");
            if (publicID != null) {
                this.internalDTDSubset.append(name);
                this.internalDTDSubset.append(" PUBLIC \"");
                this.internalDTDSubset.append(publicID);
                this.internalDTDSubset.append("\" \"");
                this.internalDTDSubset.append(systemID);
                this.internalDTDSubset.append("\" NDATA ");
                this.internalDTDSubset.append(notationName);
            } else {
                this.internalDTDSubset.append(name);
                this.internalDTDSubset.append(" SYSTEM \"");
                this.internalDTDSubset.append(systemID);
                this.internalDTDSubset.append("\" NDATA ");
                this.internalDTDSubset.append(notationName);
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    private static String escapeReservedCharactersInDeclarations(String s) {
        int length = s.length();
        StringBuffer result = new StringBuffer(length);
        block28: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\r': {
                    result.append("&#x0D;");
                    continue block28;
                }
                case '\u000e': {
                    continue block28;
                }
                case '\u000f': {
                    continue block28;
                }
                case '\u0010': {
                    continue block28;
                }
                case '\u0011': {
                    continue block28;
                }
                case '\u0012': {
                    continue block28;
                }
                case '\u0013': {
                    continue block28;
                }
                case '\u0014': {
                    continue block28;
                }
                case '\u0015': {
                    continue block28;
                }
                case '\u0016': {
                    continue block28;
                }
                case '\u0017': {
                    continue block28;
                }
                case '\u0018': {
                    continue block28;
                }
                case '\u0019': {
                    continue block28;
                }
                case '\u001a': {
                    continue block28;
                }
                case '\u001b': {
                    continue block28;
                }
                case '\u001c': {
                    continue block28;
                }
                case '\u001d': {
                    continue block28;
                }
                case '\u001e': {
                    continue block28;
                }
                case '\u001f': {
                    continue block28;
                }
                case ' ': {
                    result.append(' ');
                    continue block28;
                }
                case '!': {
                    result.append('!');
                    continue block28;
                }
                case '\"': {
                    result.append("&#x22;");
                    continue block28;
                }
                case '#': {
                    result.append('#');
                    continue block28;
                }
                case '$': {
                    result.append('$');
                    continue block28;
                }
                case '%': {
                    result.append("&#x25;");
                    continue block28;
                }
                case '&': {
                    result.append("&#x26;");
                    continue block28;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    private static String escapeReservedCharactersInDefaultAttributeValues(String s) {
        int length = s.length();
        StringBuffer result = new StringBuffer(length);
        block50: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\r': {
                    result.append("&#x0D;");
                    continue block50;
                }
                case '\u000e': {
                    continue block50;
                }
                case '\u000f': {
                    continue block50;
                }
                case '\u0010': {
                    continue block50;
                }
                case '\u0011': {
                    continue block50;
                }
                case '\u0012': {
                    continue block50;
                }
                case '\u0013': {
                    continue block50;
                }
                case '\u0014': {
                    continue block50;
                }
                case '\u0015': {
                    continue block50;
                }
                case '\u0016': {
                    continue block50;
                }
                case '\u0017': {
                    continue block50;
                }
                case '\u0018': {
                    continue block50;
                }
                case '\u0019': {
                    continue block50;
                }
                case '\u001a': {
                    continue block50;
                }
                case '\u001b': {
                    continue block50;
                }
                case '\u001c': {
                    continue block50;
                }
                case '\u001d': {
                    continue block50;
                }
                case '\u001e': {
                    continue block50;
                }
                case '\u001f': {
                    continue block50;
                }
                case ' ': {
                    result.append(' ');
                    continue block50;
                }
                case '!': {
                    result.append('!');
                    continue block50;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block50;
                }
                case '#': {
                    result.append('#');
                    continue block50;
                }
                case '$': {
                    result.append('$');
                    continue block50;
                }
                case '%': {
                    result.append("&#x25;");
                    continue block50;
                }
                case '&': {
                    result.append("&amp;");
                    continue block50;
                }
                case '\'': {
                    result.append('\'');
                    continue block50;
                }
                case '(': {
                    result.append('(');
                    continue block50;
                }
                case ')': {
                    result.append(')');
                    continue block50;
                }
                case '*': {
                    result.append('*');
                    continue block50;
                }
                case '+': {
                    result.append('+');
                    continue block50;
                }
                case ',': {
                    result.append(',');
                    continue block50;
                }
                case '-': {
                    result.append('-');
                    continue block50;
                }
                case '.': {
                    result.append('.');
                    continue block50;
                }
                case '/': {
                    result.append('/');
                    continue block50;
                }
                case '0': {
                    result.append('0');
                    continue block50;
                }
                case '1': {
                    result.append('1');
                    continue block50;
                }
                case '2': {
                    result.append('2');
                    continue block50;
                }
                case '3': {
                    result.append('3');
                    continue block50;
                }
                case '4': {
                    result.append('4');
                    continue block50;
                }
                case '5': {
                    result.append('5');
                    continue block50;
                }
                case '6': {
                    result.append('6');
                    continue block50;
                }
                case '7': {
                    result.append('7');
                    continue block50;
                }
                case '8': {
                    result.append('8');
                    continue block50;
                }
                case '9': {
                    result.append('9');
                    continue block50;
                }
                case ':': {
                    result.append(':');
                    continue block50;
                }
                case ';': {
                    result.append(';');
                    continue block50;
                }
                case '<': {
                    result.append("&lt;");
                    continue block50;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }
}

