/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;

@TestClass(value="org.openscience.cdk.renderer.generators.BasicSceneGeneratorTest")
public class BasicSceneGenerator
implements IGenerator<IAtomContainer> {
    private IGeneratorParameter<Double> arrowHeadWidth = new ArrowHeadWidth();
    private ShowTooltip showTooltip = new ShowTooltip();
    private ShowMoleculeTitle showMoleculeTitle = new ShowMoleculeTitle();
    private FitToScreen fitToScreen = new FitToScreen();
    private IGeneratorParameter<Double> scale = new Scale();
    private IGeneratorParameter<Double> bondLength = new BondLength();
    private IGeneratorParameter<Color> backgroundColor = new BackgroundColor();
    private IGeneratorParameter<Color> foregroundColor = new ForegroundColor();
    private IGeneratorParameter<Boolean> useAntiAliasing = new UseAntiAliasing();
    private IGeneratorParameter<Double> margin = new Margin();
    private IGeneratorParameter<IFontManager.FontStyle> fontStyle = new UsedFontStyle();
    private IGeneratorParameter<String> fontName = new FontName();
    private IGeneratorParameter<Double> zoomFactor = new ZoomFactor();

    public IRenderingElement generate(IAtomContainer ac, RendererModel model) {
        return new ElementGroup();
    }

    @TestMethod(value="testGetParameters")
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(new IGeneratorParameter[]{this.backgroundColor, this.foregroundColor, this.margin, this.useAntiAliasing, this.fontStyle, this.fontName, this.zoomFactor, this.scale, this.bondLength, this.fitToScreen, this.showMoleculeTitle, this.showTooltip, this.arrowHeadWidth});
    }

    public static class ZoomFactor
    extends AbstractGeneratorParameter<Double> {
        public Double getDefault() {
            return 1.0;
        }
    }

    public static class FontName
    extends AbstractGeneratorParameter<String> {
        public String getDefault() {
            return "Arial";
        }
    }

    public static class UsedFontStyle
    extends AbstractGeneratorParameter<IFontManager.FontStyle> {
        public IFontManager.FontStyle getDefault() {
            return IFontManager.FontStyle.NORMAL;
        }
    }

    public static class Margin
    extends AbstractGeneratorParameter<Double> {
        public Double getDefault() {
            return 10.0;
        }
    }

    public static class UseAntiAliasing
    extends AbstractGeneratorParameter<Boolean> {
        public Boolean getDefault() {
            return Boolean.TRUE;
        }
    }

    public static class ForegroundColor
    extends AbstractGeneratorParameter<Color> {
        public Color getDefault() {
            return Color.BLACK;
        }
    }

    public static class BondLength
    extends AbstractGeneratorParameter<Double> {
        public Double getDefault() {
            return 40.0;
        }
    }

    public static class BackgroundColor
    extends AbstractGeneratorParameter<Color> {
        public Color getDefault() {
            return Color.WHITE;
        }
    }

    public static class Scale
    extends AbstractGeneratorParameter<Double> {
        public Double getDefault() {
            return 1.0;
        }
    }

    public static class FitToScreen
    extends AbstractGeneratorParameter<Boolean> {
        public Boolean getDefault() {
            return Boolean.FALSE;
        }
    }

    public static class ShowMoleculeTitle
    extends AbstractGeneratorParameter<Boolean> {
        public Boolean getDefault() {
            return Boolean.FALSE;
        }
    }

    public static class ShowTooltip
    extends AbstractGeneratorParameter<Boolean> {
        public Boolean getDefault() {
            return Boolean.FALSE;
        }
    }

    public static class ArrowHeadWidth
    extends AbstractGeneratorParameter<Double> {
        public Double getDefault() {
            return 10.0;
        }
    }
}

