/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import uk.ac.ebi.beam.Edge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Bond {
    DOT(".", 0),
    IMPLICIT("", 1),
    IMPLICIT_AROMATIC("", 1),
    SINGLE("-", 1),
    DOUBLE("=", 2),
    DOUBLE_AROMATIC("=", 2),
    TRIPLE("#", 3),
    QUADRUPLE("$", 4),
    AROMATIC(":", 1),
    UP("/", 1){

        public Bond inverse() {
            return DOWN;
        }

        boolean directional() {
            return true;
        }
    }
    ,
    DOWN("\\", 1){

        public Bond inverse() {
            return UP;
        }

        boolean directional() {
            return true;
        }
    };

    private final String token;
    private final int order;

    private Bond(String token, int order) {
        this.token = token;
        this.order = order;
    }

    public final String token() {
        return this.token;
    }

    public int order() {
        return this.order;
    }

    public Bond inverse() {
        return this;
    }

    public Edge edge(int u, int v) {
        return new Edge(u, v, this);
    }

    boolean directional() {
        return false;
    }

    public final String toString() {
        return this.token;
    }
}

