/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.AbstractTable;
import org.xmlcml.cml.element.CMLArray;
import org.xmlcml.cml.element.CMLArrayList;
import org.xmlcml.cml.element.CMLTableContent;
import org.xmlcml.cml.element.CMLTableHeader;
import org.xmlcml.cml.element.CMLTableRow;
import org.xmlcml.cml.element.CMLTableRowList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLTable
extends AbstractTable {
    public static final String NS = "cml:table";

    public CMLTable() {
    }

    public CMLTable(CMLTable old) {
        super(old);
    }

    @Override
    public Node copy() {
        return new CMLTable(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLTable();
    }

    @Override
    public int getRows() {
        int rows = 0;
        if (this.getRowsAttribute() != null) {
            rows = super.getRows();
        } else {
            CMLArrayList arrayList = (CMLArrayList)this.getFirstCMLChild("arrayList");
            if (arrayList != null) {
                rows = arrayList.getRowCount();
            }
        }
        return rows;
    }

    public CMLElements<CMLArray> getArrayElements() {
        CMLElements<CMLArray> arrayElements = null;
        CMLArrayList arrayList = (CMLArrayList)this.getFirstCMLChild("arrayList");
        if (arrayList != null) {
            arrayElements = arrayList.getArrayElements();
        }
        return arrayElements;
    }

    @Override
    public void setTableType(String t) {
        TableType tt = TableType.getTableType(t);
        if (tt == null) {
            throw new RuntimeException("Bad table type: " + t);
        }
        if (!this.check(tt)) {
            throw new RuntimeException("bad table");
        }
        super.setTableType(t);
    }

    public void setTableType(TableType tt) {
        if (tt != null) {
            this.setTableType(tt.value);
        }
    }

    public TableType getTableTypeEnum() {
        String tableType = this.getTableType();
        return TableType.getTableType(tableType);
    }

    private void checkRowsAndColumns() {
        if (this.getRowsAttribute() == null || this.getColumnsAttribute() == null) {
            throw new RuntimeException("Must give rows and columns attributes");
        }
    }

    public boolean check(TableType t) {
        CMLTableHeader header = (CMLTableHeader)this.getFirstCMLChild("tableHeader");
        CMLArrayList arrayList = (CMLArrayList)this.getFirstCMLChild("arrayList");
        CMLTableContent content = (CMLTableContent)this.getFirstCMLChild("tableContent");
        CMLTableRowList rowList = (CMLTableRowList)this.getFirstCMLChild("tableRowList");
        boolean check = false;
        if (header == null && arrayList == null && content == null && rowList == null) {
            check = true;
        } else if (t == null) {
            check = header == null && arrayList == null && content == null && rowList == null;
        } else if (TableType.COLUMN_BASED.equals((Object)t)) {
            check = header == null && arrayList != null && content == null && rowList == null;
        } else if (TableType.CONTENT_BASED.equals((Object)t)) {
            check = header != null && arrayList == null && content != null && rowList == null;
        } else if (TableType.ROW_BASED.equals((Object)t)) {
            check = header != null && arrayList == null && content == null && rowList != null;
        }
        return check;
    }

    private CMLArrayList getOrCreateArrayList() {
        CMLArrayList arrayList = (CMLArrayList)this.getFirstCMLChild("arrayList");
        if (arrayList == null && TableType.COLUMN_BASED.value.equals(this.getTableType()) && this.getTableContentElements().size() == 0 && this.getTableRowListElements().size() == 0) {
            arrayList = new CMLArrayList();
            this.appendChild((Node)arrayList);
        }
        return arrayList;
    }

    private CMLTableRowList getOrCreateTableRowList() {
        CMLTableRowList tableRowList = (CMLTableRowList)this.getFirstCMLChild("tableRowList");
        if (tableRowList == null && TableType.ROW_BASED.value.equals(this.getTableType()) && this.getTableContentElements().size() == 0 && this.getTableRowListElements().size() == 0) {
            tableRowList = new CMLTableRowList();
            this.appendChild((Node)tableRowList);
        }
        return tableRowList;
    }

    public void addArray(CMLArray array) {
        if (this.check(TableType.COLUMN_BASED)) {
            CMLArrayList arrayList = this.getOrCreateArrayList();
            arrayList.appendChild((Node)array);
        }
    }

    @Override
    public int getColumns() {
        int columns = -1;
        if (this.getColumnsAttribute() != null) {
            columns = super.getColumns();
        } else {
            CMLArrayList arrayList = (CMLArrayList)this.getFirstCMLChild("arrayList");
            CMLTableHeader tableHeader = (CMLTableHeader)this.getFirstCMLChild("tableHeader");
            if (arrayList != null) {
                columns = arrayList.getArraysCount();
            } else if (tableHeader != null) {
                columns = tableHeader.getColumnCount();
            }
        }
        return columns;
    }

    private CMLElements<CMLTableRow> getTableRowElements() {
        CMLElements<CMLTableRow> tableRowElements = null;
        if (this.check(TableType.ROW_BASED)) {
            CMLTableRowList tableRowList = this.getOrCreateTableRowList();
            tableRowElements = tableRowList.getTableRowElements();
        }
        return tableRowElements;
    }

    public List<List<String>> getColumnValuesList() {
        ArrayList<List<String>> stringListList = new ArrayList<List<String>>();
        CMLElements<CMLArray> arrays = this.getArrayElements();
        int rows = -1;
        for (CMLArray array : arrays) {
            List<String> strings = array.getStringValues();
            int nr = strings.size();
            if (rows == -1) {
                rows = nr;
            } else if (rows != nr) {
                throw new RuntimeException("inconsistent row lengths: " + rows + "/" + nr);
            }
            stringListList.add(strings);
        }
        return stringListList;
    }

    private void writeArrays(Writer w, List<List<String>> stringListList) throws IOException {
        if (this.check(TableType.COLUMN_BASED)) {
            int columnCount = stringListList.size();
            int rowCount = stringListList.get(0).size();
            CMLElements<CMLArrayList> arrays = this.getArrayListElements();
            w.write("\n<tr>");
            for (CMLArrayList object : arrays) {
                w.write("<th>");
                w.write(((Element)object).getAttributeValue("title"));
                w.write("</th>");
            }
            w.write("</td>");
            for (int i = 0; i < rowCount; ++i) {
                w.write("\n<tr>");
                for (int j = 0; j < columnCount; ++j) {
                    w.write("<td>");
                    List<String> col = stringListList.get(j);
                    w.write(col.get(i));
                    w.write("</td>");
                }
                w.write("</tr>");
            }
        }
    }

    private void writeRows(Writer w, CMLTableHeader header, CMLElements<CMLTableRow> rows) throws IOException {
        header.writeHTML(w);
        int ncols = -1;
        for (CMLTableRow row : rows) {
            int nc = row.getTableCellElements().size();
            if (ncols == -1) {
                nc = ncols;
            } else if (nc != ncols) {
                throw new RuntimeException("inconsistent column length in rows: " + nc + "/" + ncols);
            }
            row.writeHTML(w);
        }
    }

    private void writeContent(Writer w, CMLTableHeader header, CMLTableContent content) throws IOException, RuntimeException {
        header.writeHTML(w);
        int ncols = header.getColumnCount();
        String[] strings = content.getStrings();
        if (strings.length % ncols != 0) {
            throw new RuntimeException("non-rectangular table: " + strings.length + "/" + ncols);
        }
        int count = 0;
        for (String string : strings) {
            if (count % ncols == 0) {
                w.write("\n<tr>");
            }
            w.write("<td>" + string + "</td>");
            if (++count % ncols != 0) continue;
            w.write("</tr>");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TableType {
        COLUMN_BASED("columnBased"),
        ROW_BASED("rowBased"),
        CONTENT_BASED("contentBased");

        public String value;

        private TableType(String v) {
            this.value = v;
        }

        public static TableType getTableType(String t) {
            TableType tt = null;
            for (TableType v : TableType.values()) {
                if (!v.value.equals(t)) continue;
                tt = v;
                break;
            }
            return tt;
        }
    }
}

