/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.Properties;
import org.freehep.graphics2d.GenericTagHandler;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphics2d.SymbolShape;
import org.freehep.graphics2d.TagString;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphics2d.font.FontUtilities;
import org.freehep.graphicsbase.util.UserProperties;

public abstract class AbstractVectorGraphics
extends VectorGraphics {
    private UserProperties properties;
    private String creator;
    private boolean isDeviceIndependent;
    private SymbolShape cachedShape;
    private int colorMode;
    private Color backgroundColor;
    private Color currentColor;
    private Paint currentPaint;
    private Font currentFont;
    private static final double bias = 0.5;

    public AbstractVectorGraphics() {
        this.properties = new UserProperties();
        this.creator = "FreeHEP Graphics2D Driver";
        this.isDeviceIndependent = false;
        this.cachedShape = new SymbolShape();
        this.colorMode = 0;
        this.currentFont = null;
        this.backgroundColor = null;
        this.currentColor = null;
        this.currentPaint = null;
    }

    protected AbstractVectorGraphics(AbstractVectorGraphics graphics) {
        this.properties = graphics.properties;
        this.creator = graphics.creator;
        this.isDeviceIndependent = graphics.isDeviceIndependent;
        this.cachedShape = graphics.cachedShape;
        this.backgroundColor = graphics.backgroundColor;
        this.currentColor = graphics.currentColor;
        this.currentPaint = graphics.currentPaint;
        this.colorMode = graphics.colorMode;
        this.currentFont = graphics.currentFont;
    }

    @Override
    public void setProperties(Properties newProperties) {
        if (newProperties == null) {
            return;
        }
        this.properties.setProperties(newProperties);
    }

    @Override
    protected void initProperties(Properties defaults) {
        this.properties = new UserProperties();
        this.properties.setProperties(defaults);
    }

    @Override
    protected Properties getProperties() {
        return this.properties;
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public Color getPropertyColor(String key) {
        return this.properties.getPropertyColor(key);
    }

    @Override
    public Rectangle getPropertyRectangle(String key) {
        return this.properties.getPropertyRectangle(key);
    }

    public Insets getPropertyInsets(String key) {
        return this.properties.getPropertyInsets(key);
    }

    @Override
    public Dimension getPropertyDimension(String key) {
        return this.properties.getPropertyDimension(key);
    }

    @Override
    public int getPropertyInt(String key) {
        return this.properties.getPropertyInt(key);
    }

    @Override
    public double getPropertyDouble(String key) {
        return this.properties.getPropertyDouble(key);
    }

    @Override
    public boolean isProperty(String key) {
        return this.properties.isProperty(key);
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public void setCreator(String creator) {
        if (creator != null) {
            this.creator = creator;
        }
    }

    @Override
    public boolean isDeviceIndependent() {
        return this.isDeviceIndependent;
    }

    @Override
    public void setDeviceIndependent(boolean isDeviceIndependent) {
        this.isDeviceIndependent = isDeviceIndependent;
    }

    @Override
    public Font getFont() {
        return this.currentFont;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        this.currentFont = font;
    }

    @Override
    public void drawSymbol(int x, int y, int size, int symbol) {
        this.drawSymbol((double)x, (double)y, (double)size, symbol);
    }

    @Override
    public void fillSymbol(int x, int y, int size, int symbol) {
        this.fillSymbol((double)x, (double)y, (double)size, symbol);
    }

    @Override
    public void fillAndDrawSymbol(int x, int y, int size, int symbol, Color fillColor) {
        this.fillAndDrawSymbol((double)x, (double)y, (double)size, symbol, fillColor);
    }

    @Override
    public void drawSymbol(double x, double y, double size, int symbol) {
        if (size <= 0.0) {
            return;
        }
        this.drawSymbol(this, x, y, size, symbol);
    }

    protected void drawSymbol(VectorGraphics g, double x, double y, double size, int symbol) {
        switch (symbol) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.cachedShape.create(symbol, x, y, size);
                g.draw(this.cachedShape);
                break;
            }
            case 5: {
                double diameter = Math.max(1.0, size);
                diameter += diameter % 2.0;
                g.drawOval(x - diameter / 2.0, y - diameter / 2.0, diameter, diameter);
                break;
            }
        }
    }

    @Override
    public void fillSymbol(double x, double y, double size, int symbol) {
        if (size <= 0.0) {
            return;
        }
        this.fillSymbol(this, x, y, size, symbol);
    }

    protected void fillSymbol(VectorGraphics g, double x, double y, double size, int symbol) {
        switch (symbol) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.cachedShape.create(symbol, x, y, size);
                g.draw(this.cachedShape);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.cachedShape.create(symbol, x, y, size);
                g.fill(this.cachedShape);
                break;
            }
            case 5: {
                double diameter = Math.max(1.0, size);
                diameter += diameter % 2.0;
                g.fillOval(x - diameter / 2.0, y - diameter / 2.0, diameter, diameter);
                break;
            }
        }
    }

    @Override
    public void fillAndDrawSymbol(double x, double y, double size, int symbol, Color fillColor) {
        Color color = this.getColor();
        this.setColor(fillColor);
        this.fillSymbol(x, y, size, symbol);
        this.setColor(color);
        this.drawSymbol(x, y, size, symbol);
    }

    @Override
    public void fillAndDraw(Shape s, Color fillColor) {
        Color color = this.getColor();
        this.setColor(fillColor);
        this.fill(s);
        this.setColor(color);
        this.draw(s);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.clearRect((double)x + 0.5, (double)y + 0.5, (double)width, (double)height);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.drawLine((double)x1 + 0.5, (double)y1 + 0.5, (double)x2 + 0.5, (double)y2 + 0.5);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.drawRect((double)x + 0.5, (double)y + 0.5, (double)width, (double)height);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.fillRect((double)x, (double)y, (double)width, (double)height);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.drawArc((double)x + 0.5, (double)y + 0.5, (double)width, (double)height, (double)startAngle, (double)arcAngle);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fillArc((double)x, (double)y, (double)width, (double)height, (double)startAngle, (double)arcAngle);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.drawOval((double)x + 0.5, (double)y + 0.5, (double)width, (double)height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.fillOval((double)x, (double)y, (double)width, (double)height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.drawRoundRect((double)x + 0.5, (double)y + 0.5, (double)width, (double)height, (double)arcWidth, (double)arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fillRoundRect((double)x, (double)y, (double)width, (double)height, (double)arcWidth, (double)arcHeight);
    }

    @Override
    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    @Override
    public void setLineWidth(int width) {
        this.setLineWidth((double)width);
    }

    @Override
    public void setLineWidth(double width) {
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke cs = (BasicStroke)stroke;
            if ((double)cs.getLineWidth() != width) {
                stroke = new BasicStroke((float)width, cs.getEndCap(), cs.getLineJoin(), cs.getMiterLimit(), cs.getDashArray(), cs.getDashPhase());
                this.setStroke(stroke);
            }
        } else {
            stroke = new BasicStroke((float)width);
            this.setStroke(stroke);
        }
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (double)x, (double)y);
    }

    @Override
    public void drawString(String s, float x, float y) {
        this.drawString(s, (double)x, (double)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    private Point2D drawFrameAndBanner(TextLayout tl, double x, double y, int horizontal, int vertical, boolean framed, Color frameColor, double frameWidth, boolean banner, Color bannerColor) {
        Paint paint;
        Rectangle2D bounds = tl.getBounds();
        bounds.setRect(bounds.getX(), bounds.getY(), Math.max((double)tl.getAdvance(), bounds.getWidth()), bounds.getHeight());
        AffineTransform at = AffineTransform.getTranslateInstance(x, y);
        if (horizontal == 3) {
            at.translate(-bounds.getWidth(), 0.0);
        } else if (horizontal == 2) {
            at.translate(-bounds.getWidth() / 2.0, 0.0);
        }
        if (vertical != 0) {
            if (vertical == 1) {
                at.translate(0.0, -bounds.getY());
            } else if (vertical == 2) {
                at.translate(0.0, tl.getDescent());
            } else if (vertical == 3) {
                at.translate(0.0, -bounds.getHeight() - bounds.getY());
            }
        }
        bounds = at.createTransformedShape(bounds).getBounds2D();
        Point2D result = at.transform(new Point2D.Double(0.0, 0.0), new Point2D.Double());
        double adjustment = this.getFont().getSize2D() * 2.0f / 10.0f;
        bounds.setRect(bounds.getX() - adjustment, bounds.getY() - adjustment, bounds.getWidth() + 2.0 * adjustment, bounds.getHeight() + 2.0 * adjustment);
        if (banner) {
            paint = this.getPaint();
            this.setColor(bannerColor);
            this.fill(bounds);
            this.setPaint(paint);
        }
        if (framed) {
            paint = this.getPaint();
            Stroke stroke = this.getStroke();
            this.setColor(frameColor);
            this.setLineWidth(frameWidth);
            this.draw(bounds);
            this.setPaint(paint);
            this.setStroke(stroke);
        }
        return result;
    }

    @Override
    public void drawString(String str, double x, double y, int horizontal, int vertical, boolean framed, Color frameColor, double frameWidth, boolean banner, Color bannerColor) {
        TextLayout tl = new TextLayout(str, FontUtilities.getAttributes(this.getFont()), this.getFontRenderContext());
        Point2D offset = this.drawFrameAndBanner(tl, x, y, horizontal, vertical, framed, frameColor, frameWidth, banner, bannerColor);
        this.drawString(str, offset.getX(), offset.getY());
    }

    @Override
    public void drawString(TagString str, double x, double y, int horizontal, int vertical, boolean framed, Color frameColor, double frameWidth, boolean banner, Color bannerColor) {
        GenericTagHandler tagHandler = new GenericTagHandler(this);
        TextLayout tl = tagHandler.createTextLayout(str, (double)this.getFont().getSize2D() / 7.5);
        Point2D offset = this.drawFrameAndBanner(tl, x, y, horizontal, vertical, framed, frameColor, frameWidth, banner, bannerColor);
        tagHandler.print(str, offset.getX(), offset.getY(), (double)this.getFont().getSize2D() / 7.5);
    }

    @Override
    public void drawString(String str, double x, double y, int horizontal, int vertical) {
        this.drawString(str, x, y, horizontal, vertical, false, null, 0.0, false, null);
    }

    @Override
    public void drawString(TagString str, double x, double y) {
        this.drawString(str, x, y, 1, 0);
    }

    @Override
    public void drawString(TagString str, double x, double y, int horizontal, int vertical) {
        this.drawString(str, x, y, horizontal, vertical, false, null, 0.0, false, null);
    }

    @Override
    public int getColorMode() {
        return this.colorMode;
    }

    @Override
    public void setColorMode(int colorMode) {
        this.colorMode = colorMode;
    }

    @Override
    public Color getBackground() {
        return this.backgroundColor;
    }

    @Override
    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    @Override
    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.currentColor = color;
        this.currentPaint = color;
    }

    @Override
    public Color getColor() {
        return this.currentColor;
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        if (!(paint instanceof Color)) {
            this.currentColor = null;
        }
        this.currentPaint = paint;
    }

    @Override
    public Paint getPaint() {
        return this.currentPaint;
    }

    protected Color getPrintColor(Color color) {
        if (this.colorMode == 0) {
            return color;
        }
        PrintColor printColor = PrintColor.createPrintColor(color);
        return printColor.getColor(this.colorMode);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.translate(x, y);
        this.rotate(theta);
        this.translate(-x, -y);
    }

    @Override
    public void drawArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        this.draw(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0));
    }

    @Override
    public void drawLine(double x1, double y1, double x2, double y2) {
        this.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    @Override
    public void drawOval(double x, double y, double width, double height) {
        this.draw(new Ellipse2D.Double(x, y, width, height));
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.draw(this.createShape(xPoints, yPoints, nPoints, false, true));
    }

    @Override
    public void drawPolyline(double[] xPoints, double[] yPoints, int nPoints) {
        this.draw(this.createShape(xPoints, yPoints, nPoints, false));
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.draw(this.createShape(xPoints, yPoints, nPoints, true, true));
    }

    @Override
    public void drawPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        this.draw(this.createShape(xPoints, yPoints, nPoints, true));
    }

    @Override
    public void drawRect(double x, double y, double width, double height) {
        this.draw(new Rectangle2D.Double(x, y, width, height));
    }

    @Override
    public void drawRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.draw(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void fillArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        this.fill(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 2));
    }

    @Override
    public void fillOval(double x, double y, double width, double height) {
        this.fill(new Ellipse2D.Double(x, y, width, height));
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.fill(this.createShape(xPoints, yPoints, nPoints, true, false));
    }

    @Override
    public void fillPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        this.fill(this.createShape(xPoints, yPoints, nPoints, true));
    }

    @Override
    public void fillRect(double x, double y, double width, double height) {
        this.fill(new Rectangle2D.Double(x, y, width, height));
    }

    @Override
    public void fillRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.fill(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    protected abstract Shape createShape(double[] var1, double[] var2, int var3, boolean var4);

    protected Shape createShape(int[] xPoints, int[] yPoints, int nPoints, boolean close, boolean biased) {
        float offset = biased ? 0.5f : 0.0f;
        GeneralPath path = new GeneralPath(0);
        if (nPoints > 0) {
            path.moveTo((float)xPoints[0] + offset, (float)yPoints[0] + offset);
            int lastX = xPoints[0];
            int lastY = yPoints[0];
            if (close && Math.abs(xPoints[nPoints - 1] - lastX) < 1 && Math.abs(yPoints[nPoints - 1] - lastY) < 1) {
                --nPoints;
            }
            for (int i = 1; i < nPoints; ++i) {
                if (Math.abs(xPoints[i] - lastX) <= 1 && Math.abs(yPoints[i] - lastY) <= 1) continue;
                path.lineTo((float)xPoints[i] + offset, (float)yPoints[i] + offset);
                lastX = xPoints[i];
                lastY = yPoints[i];
            }
            if (close) {
                path.closePath();
            }
        }
        return path;
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (onStroke && this.getStroke() != null) {
            s = this.getStroke().createStrokedShape(s);
        }
        if (this.getTransform() != null) {
            s = this.getTransform().createTransformedShape(s);
        }
        Area area = new Area(s);
        if (this.getClip() != null) {
            area.intersect(new Area(this.getClip()));
        }
        return area.intersects(rect);
    }
}

