/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.io.Serializable;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.silent.Element;

public class Isotope
extends Element
implements Serializable,
IIsotope,
Cloneable {
    private static final long serialVersionUID = 6389365978927575858L;
    public Double exactMass;
    public Double naturalAbundance;
    private Integer massNumber;

    public Isotope(String elementSymbol) {
        super(elementSymbol);
    }

    public Isotope(int atomicNumber, String elementSymbol, int massNumber, double exactMass, double abundance) {
        this(atomicNumber, elementSymbol, exactMass, abundance);
        this.massNumber = massNumber;
    }

    public Isotope(int atomicNumber, String elementSymbol, double exactMass, double abundance) {
        super(elementSymbol, atomicNumber);
        this.exactMass = exactMass;
        this.naturalAbundance = abundance;
    }

    public Isotope(String elementSymbol, int massNumber) {
        super(elementSymbol);
        this.massNumber = massNumber;
    }

    public Isotope(IElement element) {
        super(element);
        if (element instanceof IIsotope) {
            this.exactMass = ((IIsotope)element).getExactMass();
            this.naturalAbundance = ((IIsotope)element).getNaturalAbundance();
            this.massNumber = ((IIsotope)element).getMassNumber();
        }
    }

    @Override
    public void setNaturalAbundance(Double naturalAbundance) {
        this.naturalAbundance = naturalAbundance;
    }

    @Override
    public void setExactMass(Double exactMass) {
        this.exactMass = exactMass;
    }

    @Override
    public Double getNaturalAbundance() {
        return this.naturalAbundance;
    }

    @Override
    public Double getExactMass() {
        return this.exactMass;
    }

    @Override
    public Integer getMassNumber() {
        return this.massNumber;
    }

    @Override
    public void setMassNumber(Integer massNumber) {
        this.massNumber = massNumber;
    }

    @Override
    public String toString() {
        StringBuffer resultString = new StringBuffer(32);
        resultString.append("Isotope(").append(this.hashCode());
        if (this.massNumber != null) {
            resultString.append(", MN:").append(this.massNumber);
        }
        if (this.exactMass != null) {
            resultString.append(", EM:");
            resultString.append(this.exactMass);
        }
        if (this.naturalAbundance != null) {
            resultString.append(", AB:");
            resultString.append(this.naturalAbundance);
        }
        resultString.append(", ").append(super.toString());
        resultString.append(')');
        return resultString.toString();
    }

    @Override
    public boolean compare(Object object) {
        double diff;
        if (!(object instanceof Isotope)) {
            return false;
        }
        if (!super.compare(object)) {
            return false;
        }
        Isotope isotope = (Isotope)object;
        if (isotope.getMassNumber() != null && this.massNumber != null && isotope.getMassNumber().intValue() != this.getMassNumber().intValue()) {
            return false;
        }
        if (isotope.getMassNumber() == null && this.massNumber != null) {
            return false;
        }
        if (isotope.getExactMass() != null && this.exactMass != null && (diff = Math.abs(isotope.getExactMass() - this.getExactMass())) > 1.0E-7) {
            return false;
        }
        if (isotope.getExactMass() == null && this.exactMass != null) {
            return false;
        }
        if (isotope.getNaturalAbundance() != null && this.naturalAbundance != null && (diff = Math.abs(isotope.getNaturalAbundance() - this.getNaturalAbundance())) > 1.0E-7) {
            return false;
        }
        return isotope.getNaturalAbundance() != null || this.naturalAbundance == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

