/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.ChemObjectRef;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class BondRef
extends ChemObjectRef
implements IBond {
    private final IBond bond;

    public BondRef(IBond bond) {
        super(bond);
        this.bond = bond;
    }

    public static IBond deref(IBond bond) {
        while (bond instanceof BondRef) {
            bond = ((BondRef)bond).deref();
        }
        return bond;
    }

    public IBond deref() {
        return this.bond;
    }

    @Override
    public Integer getElectronCount() {
        return this.bond.getElectronCount();
    }

    @Override
    public void setElectronCount(Integer count) {
        this.bond.setElectronCount(count);
    }

    @Override
    public Iterable<IAtom> atoms() {
        return this.bond.atoms();
    }

    @Override
    public void setAtoms(IAtom[] atoms) {
        this.bond.setAtoms(atoms);
    }

    @Override
    public IAtom getBegin() {
        return this.bond.getBegin();
    }

    @Override
    public IAtom getEnd() {
        return this.bond.getEnd();
    }

    @Override
    public int getIndex() {
        return this.bond.getIndex();
    }

    @Override
    public IAtomContainer getContainer() {
        return this.bond.getContainer();
    }

    @Override
    public int getAtomCount() {
        return this.bond.getAtomCount();
    }

    @Override
    public IAtom getAtom(int position) {
        return this.bond.getAtom(position);
    }

    @Override
    public IAtom getConnectedAtom(IAtom atom) {
        return this.bond.getConnectedAtom(atom);
    }

    @Override
    public IAtom getOther(IAtom atom) {
        return this.bond.getOther(atom);
    }

    @Override
    public IAtom[] getConnectedAtoms(IAtom atom) {
        return this.bond.getConnectedAtoms(atom);
    }

    @Override
    public boolean contains(IAtom atom) {
        return this.bond.contains(atom);
    }

    @Override
    public void setAtom(IAtom atom, int position) {
        this.bond.setAtom(atom, position);
    }

    @Override
    public IBond.Order getOrder() {
        return this.bond.getOrder();
    }

    @Override
    public void setOrder(IBond.Order order) {
        this.bond.setOrder(order);
    }

    @Override
    public IBond.Stereo getStereo() {
        return this.bond.getStereo();
    }

    @Override
    public void setStereo(IBond.Stereo stereo) {
        this.bond.setStereo(stereo);
    }

    @Override
    public IBond.Display getDisplay() {
        return this.bond.getDisplay();
    }

    @Override
    public void setDisplay(IBond.Display display) {
        this.bond.setDisplay(display);
    }

    @Override
    public Point2d get2DCenter() {
        return this.bond.get2DCenter();
    }

    @Override
    public Point3d get3DCenter() {
        return this.bond.get3DCenter();
    }

    @Override
    public boolean compare(Object object) {
        return this.bond.compare(object);
    }

    @Override
    public boolean isConnectedTo(IBond bond) {
        return this.bond.isConnectedTo(bond);
    }

    @Override
    public boolean isAromatic() {
        return this.bond.isAromatic();
    }

    @Override
    public void setIsAromatic(boolean arom) {
        this.bond.setIsAromatic(arom);
    }

    @Override
    public boolean isInRing() {
        return this.bond.isInRing();
    }

    @Override
    public void setIsInRing(boolean ring) {
        this.bond.setIsInRing(ring);
    }

    public int hashCode() {
        return this.bond.hashCode();
    }

    public boolean equals(Object obj) {
        return this.bond.equals(obj);
    }

    @Override
    public IBond clone() throws CloneNotSupportedException {
        return this.bond.clone();
    }

    @Override
    public String toString() {
        return "BondRef{" + this.bond + "}";
    }
}

