/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.group;

import org.openscience.cdk.group.AbstractDiscretePartitionRefiner;
import org.openscience.cdk.group.AtomContainerDiscretePartitionRefiner;
import org.openscience.cdk.group.EquitablePartitionRefiner;
import org.openscience.cdk.group.Partition;
import org.openscience.cdk.group.Permutation;
import org.openscience.cdk.group.PermutationGroup;
import org.openscience.cdk.group.Refinable;
import org.openscience.cdk.interfaces.IAtomContainer;

abstract class AtomContainerDiscretePartitionRefinerImpl
extends AbstractDiscretePartitionRefiner
implements AtomContainerDiscretePartitionRefiner {
    private Refinable refinable;

    AtomContainerDiscretePartitionRefinerImpl() {
    }

    @Override
    public void refine(IAtomContainer atomContainer) {
        this.refine(atomContainer, this.getRefinable(atomContainer).getInitialPartition());
    }

    @Override
    public void refine(IAtomContainer atomContainer, Partition partition) {
        this.setup(atomContainer);
        super.refine(partition);
    }

    @Override
    public boolean isCanonical(IAtomContainer atomContainer) {
        this.setup(atomContainer);
        super.refine(this.refinable.getInitialPartition());
        return this.isCanonical();
    }

    @Override
    public PermutationGroup getAutomorphismGroup(IAtomContainer atomContainer) {
        this.setup(atomContainer);
        super.refine(this.refinable.getInitialPartition());
        return super.getAutomorphismGroup();
    }

    @Override
    public PermutationGroup getAutomorphismGroup(IAtomContainer atomContainer, PermutationGroup group) {
        this.setup(atomContainer, group);
        super.refine(this.refinable.getInitialPartition());
        return super.getAutomorphismGroup();
    }

    @Override
    public PermutationGroup getAutomorphismGroup(IAtomContainer atomContainer, Partition initialPartition) {
        this.setup(atomContainer);
        super.refine(initialPartition);
        return super.getAutomorphismGroup();
    }

    @Override
    public Partition getAutomorphismPartition(IAtomContainer atomContainer) {
        this.setup(atomContainer);
        super.refine(this.refinable.getInitialPartition());
        return super.getAutomorphismPartition();
    }

    protected abstract Refinable createRefinable(IAtomContainer var1);

    private Refinable getRefinable(IAtomContainer atomContainer) {
        this.refinable = this.createRefinable(atomContainer);
        return this.refinable;
    }

    @Override
    protected int getVertexCount() {
        return this.refinable.getVertexCount();
    }

    @Override
    protected int getConnectivity(int vertexI, int vertexJ) {
        return this.refinable.getConnectivity(vertexI, vertexJ);
    }

    private void setup(IAtomContainer atomContainer) {
        Refinable refinable = this.getRefinable(atomContainer);
        int size = this.getVertexCount();
        PermutationGroup group = new PermutationGroup(new Permutation(size));
        super.setup(group, new EquitablePartitionRefiner(refinable));
    }

    private void setup(IAtomContainer atomContainer, PermutationGroup group) {
        super.setup(group, new EquitablePartitionRefiner(this.getRefinable(atomContainer)));
    }
}

