/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.matrix.AdjacencyMatrix;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class EccentricConnectivityIndexDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static final String[] NAMES = new String[]{"ECCEN"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#eccentricConnectivityIndex", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer container) {
        IAtomContainer local = AtomContainerManipulator.removeHydrogens(container);
        int natom = local.getAtomCount();
        int[][] admat = AdjacencyMatrix.getMatrix(local);
        int[][] distmat = PathTools.computeFloydAPSP(admat);
        int eccenindex = 0;
        for (int i = 0; i < natom; ++i) {
            int max = -1;
            for (int j = 0; j < natom; ++j) {
                if (distmat[i][j] <= max) continue;
                max = distmat[i][j];
            }
            int degree = local.getConnectedBondsCount(i);
            eccenindex += max * degree;
        }
        IntegerResult retval = new IntegerResult(eccenindex);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), retval, this.getDescriptorNames(), null);
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }
}

