/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.inchi;

import io.github.dan2097.jnainchi.InchiAtom;
import io.github.dan2097.jnainchi.InchiBond;
import io.github.dan2097.jnainchi.InchiBondStereo;
import io.github.dan2097.jnainchi.InchiBondType;
import io.github.dan2097.jnainchi.InchiInput;
import io.github.dan2097.jnainchi.InchiInputFromInchiOutput;
import io.github.dan2097.jnainchi.InchiOptions;
import io.github.dan2097.jnainchi.InchiStatus;
import io.github.dan2097.jnainchi.InchiStereo;
import io.github.dan2097.jnainchi.InchiStereoParity;
import io.github.dan2097.jnainchi.InchiStereoType;
import io.github.dan2097.jnainchi.JnaInchi;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import net.sf.jniinchi.INCHI_RET;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.inchi.InChIOptionParser;
import org.openscience.cdk.inchi.JniInchiSupport;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.DoubleBondStereochemistry;
import org.openscience.cdk.stereo.ExtendedCisTrans;
import org.openscience.cdk.stereo.ExtendedTetrahedral;

public class InChIToStructure {
    protected InchiInputFromInchiOutput output;
    protected InchiOptions options;
    protected IAtomContainer molecule;
    private static final int ISOTOPIC_SHIFT_FLAG = 10000;
    private static final int ISOTOPIC_SHIFT_THRESHOLD = 9900;

    protected InChIToStructure(String inchi, IChemObjectBuilder builder, InchiOptions options) throws CDKException {
        if (inchi == null) {
            throw new IllegalArgumentException("Null InChI string provided");
        }
        if (options == null) {
            throw new IllegalArgumentException("Null options provided");
        }
        this.output = JnaInchi.getInchiInputFromInchi((String)inchi);
        this.options = options;
        this.generateAtomContainerFromInchi(builder);
    }

    protected InChIToStructure(String inchi, IChemObjectBuilder builder) throws CDKException {
        this(inchi, builder, new InchiOptions.InchiOptionsBuilder().build());
    }

    protected InChIToStructure(String inchi, IChemObjectBuilder builder, String options) throws CDKException {
        this(inchi, builder, InChIOptionParser.parseString(options));
    }

    protected InChIToStructure(String inchi, IChemObjectBuilder builder, List<String> options) throws CDKException {
        this(inchi, builder, InChIOptionParser.parseStrings(options));
    }

    private void flip(IBond bond) {
        bond.setAtoms(new IAtom[]{bond.getEnd(), bond.getBegin()});
    }

    protected void generateAtomContainerFromInchi(IChemObjectBuilder builder) throws CDKException {
        InchiInput input = this.output.getInchiInput();
        this.molecule = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[0]);
        HashMap<Object, IAtom> inchiCdkAtomMap = new HashMap<Object, IAtom>();
        List atoms = input.getAtoms();
        for (int i = 0; i < atoms.size(); ++i) {
            InchiAtom iAt = (InchiAtom)atoms.get(i);
            IAtom cAt = (IAtom)builder.newInstance(IAtom.class, new Object[0]);
            inchiCdkAtomMap.put(iAt, cAt);
            cAt.setID("a" + i);
            cAt.setAtomicNumber(Integer.valueOf(Elements.ofString((String)iAt.getElName()).number()));
            cAt.setFormalCharge(Integer.valueOf(iAt.getCharge()));
            cAt.setImplicitHydrogenCount(Integer.valueOf(iAt.getImplicitHydrogen()));
            int isotopicMass = iAt.getIsotopicMass();
            if (isotopicMass != 0) {
                if (isotopicMass > 9900) {
                    try {
                        int massNumber = Isotopes.getInstance().getMajorIsotope(cAt.getAtomicNumber().intValue()).getMassNumber();
                        cAt.setMassNumber(Integer.valueOf(massNumber + (isotopicMass - 10000)));
                    }
                    catch (IOException e) {
                        throw new CDKException("Could not load Isotopes data", (Throwable)e);
                    }
                } else {
                    cAt.setMassNumber(Integer.valueOf(isotopicMass));
                }
            }
            this.molecule.addAtom(cAt);
            cAt = this.molecule.getAtom(this.molecule.getAtomCount() - 1);
            this.addHydrogenIsotopes(builder, cAt, 2, iAt.getImplicitDeuterium());
            this.addHydrogenIsotopes(builder, cAt, 3, iAt.getImplicitTritium());
        }
        List bonds = input.getBonds();
        for (InchiBond iBo : bonds) {
            IBond cBo = (IBond)builder.newInstance(IBond.class, new Object[0]);
            IAtom atO = (IAtom)inchiCdkAtomMap.get(iBo.getStart());
            IAtom atT = (IAtom)inchiCdkAtomMap.get(iBo.getEnd());
            cBo.setAtoms(new IAtom[]{atO, atT});
            InchiBondType type = iBo.getType();
            switch (type) {
                case SINGLE: {
                    cBo.setOrder(IBond.Order.SINGLE);
                    break;
                }
                case DOUBLE: {
                    cBo.setOrder(IBond.Order.DOUBLE);
                    break;
                }
                case TRIPLE: {
                    cBo.setOrder(IBond.Order.TRIPLE);
                    break;
                }
                case ALTERN: {
                    cBo.setIsInRing(true);
                    break;
                }
                default: {
                    throw new CDKException("Unknown bond type: " + type);
                }
            }
            InchiBondStereo stereo = iBo.getStereo();
            switch (stereo) {
                case NONE: {
                    cBo.setStereo(IBond.Stereo.NONE);
                    break;
                }
                case SINGLE_1DOWN: {
                    cBo.setStereo(IBond.Stereo.DOWN);
                    break;
                }
                case SINGLE_1UP: {
                    cBo.setStereo(IBond.Stereo.UP);
                    break;
                }
                case SINGLE_2DOWN: {
                    cBo.setStereo(IBond.Stereo.DOWN_INVERTED);
                    break;
                }
                case SINGLE_2UP: {
                    cBo.setStereo(IBond.Stereo.UP_INVERTED);
                    break;
                }
                case SINGLE_1EITHER: {
                    cBo.setStereo(IBond.Stereo.UP_OR_DOWN);
                    break;
                }
                case SINGLE_2EITHER: {
                    cBo.setStereo(IBond.Stereo.UP_OR_DOWN_INVERTED);
                }
            }
            this.molecule.addBond(cBo);
        }
        List stereos = input.getStereos();
        for (InchiStereo stereo0d : stereos) {
            if (stereo0d.getType() == InchiStereoType.Tetrahedral || stereo0d.getType() == InchiStereoType.Allene) {
                ITetrahedralChirality.Stereo stereo;
                InchiAtom central = stereo0d.getCentralAtom();
                InchiAtom[] neighbours = stereo0d.getAtoms();
                IAtom focus = (IAtom)inchiCdkAtomMap.get(central);
                IAtom[] neighbors = new IAtom[]{(IAtom)inchiCdkAtomMap.get(neighbours[0]), (IAtom)inchiCdkAtomMap.get(neighbours[1]), (IAtom)inchiCdkAtomMap.get(neighbours[2]), (IAtom)inchiCdkAtomMap.get(neighbours[3])};
                if (stereo0d.getParity() == InchiStereoParity.ODD) {
                    stereo = ITetrahedralChirality.Stereo.ANTI_CLOCKWISE;
                } else {
                    if (stereo0d.getParity() != InchiStereoParity.EVEN) continue;
                    stereo = ITetrahedralChirality.Stereo.CLOCKWISE;
                }
                IStereoElement stereoElement = null;
                if (stereo0d.getType() == InchiStereoType.Tetrahedral) {
                    stereoElement = (IStereoElement)builder.newInstance(ITetrahedralChirality.class, new Object[]{focus, neighbors, stereo});
                } else if (stereo0d.getType() == InchiStereoType.Allene) {
                    IAtom[] terminals;
                    IAtom[] peripherals = neighbors;
                    for (IAtom terminal : terminals = ExtendedTetrahedral.findTerminalAtoms((IAtomContainer)this.molecule, (IAtom)focus)) {
                        if (peripherals[1].equals((Object)terminal)) {
                            peripherals[1] = InChIToStructure.findOtherSinglyBonded(this.molecule, terminal, peripherals[0]);
                            continue;
                        }
                        if (peripherals[2].equals((Object)terminal)) {
                            peripherals[2] = InChIToStructure.findOtherSinglyBonded(this.molecule, terminal, peripherals[3]);
                            continue;
                        }
                        if (peripherals[0].equals((Object)terminal)) {
                            peripherals[0] = InChIToStructure.findOtherSinglyBonded(this.molecule, terminal, peripherals[1]);
                            continue;
                        }
                        if (!peripherals[3].equals((Object)terminal)) continue;
                        peripherals[3] = InChIToStructure.findOtherSinglyBonded(this.molecule, terminal, peripherals[2]);
                    }
                    stereoElement = new ExtendedTetrahedral(focus, peripherals, stereo);
                }
                assert (stereoElement != null);
                this.molecule.addStereoElement(stereoElement);
                continue;
            }
            if (stereo0d.getType() != InchiStereoType.DoubleBond) continue;
            boolean extended = false;
            InchiAtom[] neighbors = stereo0d.getAtoms();
            IAtom x = (IAtom)inchiCdkAtomMap.get(neighbors[0]);
            IAtom a = (IAtom)inchiCdkAtomMap.get(neighbors[1]);
            IAtom b = (IAtom)inchiCdkAtomMap.get(neighbors[2]);
            IAtom y = (IAtom)inchiCdkAtomMap.get(neighbors[3]);
            IBond stereoBond = this.molecule.getBond(a, b);
            if (stereoBond == null) {
                extended = true;
                Object tmp = null;
                stereoBond = ExtendedCisTrans.findCentralBond((IAtomContainer)this.molecule, (IAtom)a);
                if (stereoBond == null) continue;
                IAtom[] ends = ExtendedCisTrans.findTerminalAtoms((IAtomContainer)this.molecule, (IBond)stereoBond);
                assert (ends != null);
                if (ends[0] != a) {
                    this.flip(stereoBond);
                }
            } else if (!stereoBond.getBegin().equals((Object)a)) {
                this.flip(stereoBond);
            }
            int config = 2;
            if (stereo0d.getParity() == InchiStereoParity.EVEN) {
                config = 1;
            }
            if (extended) {
                this.molecule.addStereoElement((IStereoElement)new ExtendedCisTrans(stereoBond, new IBond[]{this.molecule.getBond(x, a), this.molecule.getBond(b, y)}, config));
                continue;
            }
            this.molecule.addStereoElement((IStereoElement)new DoubleBondStereochemistry(stereoBond, new IBond[]{this.molecule.getBond(x, a), this.molecule.getBond(b, y)}, config));
        }
    }

    private void addHydrogenIsotopes(IChemObjectBuilder builder, IAtom cAt, int mass, int count) {
        for (int j = 0; j < count; ++j) {
            IAtom deut = (IAtom)builder.newInstance(IAtom.class, new Object[0]);
            deut.setAtomicNumber(Integer.valueOf(1));
            deut.setSymbol("H");
            deut.setMassNumber(Integer.valueOf(mass));
            deut.setImplicitHydrogenCount(Integer.valueOf(0));
            this.molecule.addAtom(deut);
            deut = this.molecule.getAtom(this.molecule.getAtomCount() - 1);
            IBond bond = (IBond)builder.newInstance(IBond.class, new Object[]{cAt, deut, IBond.Order.SINGLE});
            this.molecule.addBond(bond);
        }
    }

    private static IAtom findOtherSinglyBonded(IAtomContainer container, IAtom atom, IAtom exclude) {
        for (IBond bond : container.getConnectedBondsList(atom)) {
            if (!IBond.Order.SINGLE.equals((Object)bond.getOrder()) || bond.contains(exclude)) continue;
            return bond.getOther(atom);
        }
        return atom;
    }

    public IAtomContainer getAtomContainer() {
        return this.molecule;
    }

    @Deprecated
    public INCHI_RET getReturnStatus() {
        return JniInchiSupport.toJniStatus(this.output.getStatus());
    }

    public InchiStatus getStatus() {
        return this.output.getStatus();
    }

    public String getMessage() {
        return this.output.getMessage();
    }

    public String getLog() {
        return this.output.getLog();
    }

    public long[][] getWarningFlags() {
        return this.output.getWarningFlags();
    }
}

