/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Element;
import nu.xom.Node;
import org.xmlcml.cml.base.AbstractGenerator;
import org.xmlcml.cml.base.AttributeFactory;
import org.xmlcml.cml.base.CMLAttribute;
import org.xmlcml.cml.base.CMLType;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.base.SchemaManager;
import org.xmlcml.euclid.Util;

public class AttributeGenerator
extends AbstractGenerator {
    private Map<String, CMLAttribute> attributeGroupMap;

    public AttributeGenerator(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.init();
    }

    private void init() {
        this.attributeGroupMap = new HashMap<String, CMLAttribute>();
        this.nameList = new ArrayList();
    }

    public void readAssembleAndIndexSchema(String indir) throws Exception {
        this.schema = this.readAndAssembleSchemaComponents(indir);
        this.indexSchema();
    }

    public void indexSchema() {
        List<Node> attributeGroups = CMLUtil.getQueryNodes((Node)this.schema, "./xsd:attributeGroup", XPATH_XSD);
        for (Node node : attributeGroups) {
            Element attributeGroupElement = (Element)node;
            String attributeGroupName = attributeGroupElement.getAttributeValue("name");
            if (attributeGroupName == null) {
                System.err.println("No name attribute on attribute");
                continue;
            }
            CMLAttribute attribute = this.createAttribute(attributeGroupName);
            this.attributeGroupMap.put(attributeGroupName, attribute);
            this.nameList.add(attributeGroupName);
        }
    }

    public CMLAttribute createAttribute(String attributeGroupName) {
        String typeS;
        CMLAttribute attribute = null;
        List<Node> attributeGroups = CMLUtil.getQueryNodes((Node)this.schema, "./xsd:attributeGroup[@name='" + attributeGroupName + "']", XPATH_XSD);
        if (attributeGroups.size() != 1) {
            throw new RuntimeException("Cannot find unique attributeGroup: " + attributeGroupName);
        }
        Element attributeGroup = (Element)attributeGroups.get(0);
        List<Node> attributes = CMLUtil.getQueryNodes((Node)attributeGroup, "./xsd:attribute", XPATH_XSD);
        if (attributes.size() != 1) {
            throw new RuntimeException("Cannot find unique attribute: " + attributeGroupName);
        }
        Element attributeElement = (Element)attributes.get(0);
        String attributeName = attributeElement.getAttributeValue("name");
        if (!attributeName.equals(attributeGroupName)) {
            // empty if block
        }
        if ((typeS = attributeElement.getAttributeValue("type")) == null) {
            throw new RuntimeException("No type given for attribute " + attributeGroupName);
        }
        Map<String, CMLType> typeMap = this.schemaManager.getTypeGenerator().getMap();
        CMLType type = typeMap.get(typeS);
        if (type == null) {
            for (String sss : typeMap.keySet()) {
                Util.println((String)sss);
            }
            throw new RuntimeException("Cannot find CMLType for " + typeS);
        }
        attribute = AttributeFactory.createCMLAttribute(attributeName, type);
        List<Node> summarys = CMLUtil.getQueryNodes((Node)attributeElement, ".//*[@class='summary']");
        String summary = summarys.size() == 0 ? "No summary" : summarys.get(0).getValue();
        attribute.setSummary(summary);
        List<Node> descriptions = CMLUtil.getQueryNodes((Node)attributeElement, ".//*[@class='description']");
        String description = descriptions.size() == 0 ? "No description" : descriptions.get(0).getValue();
        attribute.setDescription(description);
        return attribute;
    }

    void printAttributes() {
        for (String name : this.nameList) {
            Util.println((String)name);
        }
    }

    public Map<String, CMLAttribute> getAttributeGroupMap() {
        return this.attributeGroupMap;
    }

    public void setAttributeGroupMap(Map<String, CMLAttribute> attributeGroupMap) {
        this.attributeGroupMap = attributeGroupMap;
    }
}

