/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.graph.JumboPathGraph;
import org.openscience.cdk.graph.PathGraph;
import org.openscience.cdk.graph.RegularPathGraph;

public final class AllCycles {
    private final List<int[]> cycles = new ArrayList<int[]>();
    private final boolean completed;

    public AllCycles(int[][] graph, int maxCycleSize, int maxDegree) {
        int[] rank = AllCycles.rank(graph);
        int[] vertices = AllCycles.verticesInOrder(rank);
        PathGraph pGraph = graph.length < 64 ? new RegularPathGraph(graph, rank, maxCycleSize) : new JumboPathGraph(graph, rank, maxCycleSize);
        int removed = 0;
        for (int v : vertices) {
            if (pGraph.degree(v) > maxDegree) break;
            pGraph.remove(v, this.cycles);
            ++removed;
        }
        this.completed = removed == graph.length;
    }

    static int[] verticesInOrder(int[] rank) {
        int[] vs = new int[rank.length];
        for (int v = 0; v < rank.length; ++v) {
            vs[rank[v]] = v;
        }
        return vs;
    }

    static int[] rank(int[][] g) {
        int ord = g.length;
        int[] count = new int[ord + 1];
        int[] rank = new int[ord];
        for (int[] ints : g) {
            int n = ints.length + 1;
            count[n] = count[n] + 1;
        }
        int i = 0;
        while (count[i] < ord) {
            int n = i + 1;
            count[n] = count[n] + count[i];
            ++i;
        }
        for (int v = 0; v < ord; ++v) {
            int n = g[v].length;
            count[n] = count[n] + 1;
        }
        return rank;
    }

    public int[][] paths() {
        int[][] paths = new int[this.cycles.size()][];
        for (int i = 0; i < this.cycles.size(); ++i) {
            paths[i] = (int[])this.cycles.get(i).clone();
        }
        return paths;
    }

    public int size() {
        return this.cycles.size();
    }

    public boolean completed() {
        return this.completed;
    }
}

