/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.StdErrLogger;

public class LoggingToolFactory {
    public static final String DEFAULT_LOGGING_TOOL_CLASS = "org.openscience.cdk.tools.Slf4jLoggingTool";
    private static final String BACKUP_LOGGING_TOOL_CLASS = "org.openscience.cdk.tools.Log4jLoggingTool";
    private static Class<? extends ILoggingTool> userSetILoggerTool;

    public static void setLoggingToolClass(Class<? extends ILoggingTool> loggingTool) {
        userSetILoggerTool = loggingTool;
    }

    public static Class<? extends ILoggingTool> getLoggingToolClass() {
        return userSetILoggerTool;
    }

    public static ILoggingTool createLoggingTool(Class<?> sourceClass) {
        ILoggingTool tool = null;
        if (userSetILoggerTool != null) {
            tool = LoggingToolFactory.instantiateWithCreateMethod(sourceClass, userSetILoggerTool);
        }
        if (tool == null) {
            tool = LoggingToolFactory.initializeLoggingTool(sourceClass, DEFAULT_LOGGING_TOOL_CLASS);
        }
        if (tool == null) {
            tool = LoggingToolFactory.initializeLoggingTool(sourceClass, BACKUP_LOGGING_TOOL_CLASS);
        }
        if (tool == null) {
            tool = new StdErrLogger(sourceClass);
        }
        return tool;
    }

    private static ILoggingTool initializeLoggingTool(Class<?> sourceClass, String className) {
        try {
            Class<?> possibleLoggingToolClass = sourceClass.getClassLoader().loadClass(className);
            if (ILoggingTool.class.isAssignableFrom(possibleLoggingToolClass)) {
                return LoggingToolFactory.instantiateWithCreateMethod(sourceClass, possibleLoggingToolClass);
            }
        }
        catch (ClassNotFoundException possibleLoggingToolClass) {
        }
        catch (IllegalArgumentException | SecurityException e) {
            throw new RuntimeException("Could not create logging class: " + className, e);
        }
        return null;
    }

    private static ILoggingTool instantiateWithCreateMethod(Class<?> sourceClass, Class<?> loggingToolClass) {
        try {
            Method createMethod = loggingToolClass.getMethod("create", Class.class);
            Object createdLoggingTool = createMethod.invoke(null, sourceClass);
            if (createdLoggingTool instanceof ILoggingTool) {
                return (ILoggingTool)createdLoggingTool;
            }
            System.out.println("Expected ILoggingTool, but found a:" + createdLoggingTool.getClass().getName());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Could not create custom logging class", e);
        }
        return null;
    }
}

