% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{beta.lm}
\alias{beta.aov}
\alias{beta.lm}
\title{Standardized coeffients of a model.}
\usage{
\method{beta}{lm}(model, x = TRUE, y = TRUE, skip = NULL, ...)

\method{beta}{aov}(model, x = TRUE, y = TRUE, skip = NULL, ...)
}
\arguments{
\item{model}{A fitted linear model of type 'lm'.}

\item{x}{Logical. Whether or not to standardize predictor variables.}

\item{y}{Logical. Whether or not to standardize criterion variables.}

\item{skip}{A string vector indicating any variables you do \emph{not} wish
to be standarized.}

\item{...}{Not currently implemented; used to ensure consistency with S3 generic.}
}
\value{
Returns the summary of a linear model, with the output showing the
  beta coefficients, standard error, t-values, and p-values for each
  predictor.
}
\description{
\code{beta.lm} returns the summary of a linear model where all variables have
been standardized.
}
\details{
This function takes a linear regression model and standardizes the variables,
in order to produce standardized (i.e., beta) coefficients rather than
unstandardized (i.e., B) coefficients.

Unlike similar functions, this function properly calculates standardized
estimates for interaction terms (by first standardizing each of the
individual predictor variables).
}
\examples{
# iris data
model1 <- lm(Sepal.Length ~ Petal.Length + Petal.Width, iris)
beta(model1)  # all three variables standardized

model2 <- lm(Sepal.Width ~ Petal.Width + Species, iris)
beta(model2, skip='Species')  # all variables except Species standardized
}
\seealso{
\code{\link{beta.glm}}
}

