% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_handlers}
\alias{repo_handlers}
\title{Provides simplified access to repo items.}
\usage{
repo_handlers(repo)
}
\arguments{
\item{repo}{An object of class repo.}
}
\value{
A list of functions.
}
\description{
Creates a list of functions, each one associated with a repository
item, that can be used to access items more directly.
}
\details{
Repository handlers are functions associated with
items. As opposed to item names, they can take advantage of IDE
autocompletion features and do not require quotation marks. An
handler to the \code{repo} object itself is provided in the list.
}
\examples{
repo_path <- file.path(tempdir(), "example_repo")
repo <- repo_open(repo_path, TRUE)

## Putting some irrelevant data
repo$put(1, "item1", "Sample item 1", "repo_handlers", replace=TRUE)
repo$put(2, "item2", "Sample item 2", "repo_handlers", replace=TRUE)

## Getting item handlers
h <- repo$handlers()
## handlers have the same names as the items in the repo (and they include
## an handler to the repo itself).
names(h)

## Without arguments, function "item1" loads item named "item1".
i1 <- h$item1()

## Arguments can be used to call other repo functions on the item.
h$item1("info")

## After putting new data, the handlers must be refreshed.
repo$put(3, "item3", "Sample item 3", "repo_handlers", replace=TRUE)
h <- repo$handlers()
names(h)

## wiping temporary repo
unlink(repo_path, TRUE)
}

