% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_set}
\alias{repo_set}
\title{Edit an existing item.}
\usage{
repo_set(repo, name, obj = NULL, newname = NULL, description = NULL,
  tags = NULL, src = NULL, addtags = NULL)
}
\arguments{
\item{repo}{An object of class repo.}

\item{name}{An item name.}

\item{obj}{An R object to replace the one currently associated with the item.}

\item{newname}{Newname of the item.}

\item{description}{Item's description.}

\item{tags}{New item's tags as a ist of character.}

\item{src}{New item's provenance as a list of character.}

\item{addtags}{Tags to be added to current item's tags. Can not be
used together with the parameter "tags".}
}
\value{
Used for side effects.
}
\description{
Edit an existing item.
}
\examples{
repo_path <- file.path(tempdir(), "example_repo")
repo <- repo_open(repo_path, TRUE)
repo$put(1, "item1", "Sample item 1", c("tag1", "tag2"), replace=TRUE)
repo$set("item1", obj=2)
print(repo$get("item1"))
repo$set("item1", description="Modified description", tags="new_tag_set")
repo$info("item1")

## wiping temporary repo
unlink(repo_path, TRUE)
}
\seealso{
repo_put
}

