% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ex_data_frame.R
\name{rquery_apply_to_data_frame}
\alias{rquery_apply_to_data_frame}
\title{Execture optree in an enviroment where d is the only data.}
\usage{
rquery_apply_to_data_frame(d, optree, env = parent.frame(),
  result_limit = NULL)
}
\arguments{
\item{d}{data.frame}

\item{optree}{rquery rel_op operation tree.}

\item{env}{environment to look for "winvector_temp_db_handle" in.}

\item{result_limit}{numeric if not null limit result to this many rows.}
}
\value{
data.frame result
}
\description{
Default DB uses RSQLite (so some functions are not supported).
}
\examples{

winvector_temp_db_handle <- list(
  db = DBI::dbConnect(RSQLite::SQLite(), ":memory:")
)
RSQLite::initExtension(winvector_temp_db_handle$db)

d <- data.frame(AUC = 0.6, R2 = c(0.1, 0.2), D = NA, z = 2)
optree <- table_source("d", c("AUC", "R2", "D")) \%.>\%
	extend_nse(., c := sqrt(R2)) \%.>\%
  orderby(., rev_cols = "R2")

rquery_apply_to_data_frame(d, optree)

execute_data_frame(optree, data = d)

d \%.>\% optree

# run (and build result for) ad-hoc query
d \%.>\%
  extend_nse(., c := sqrt(R2)) \%.>\%
  orderby(., rev_cols = "R2") \%.>\%
  execute_data_frame(.)
# print ad-hoc query (result only available for printing)
d \%.>\%
  extend_nse(., c := sqrt(R2)) \%.>\%
  orderby(., rev_cols = "R2")

DBI::dbDisconnect(winvector_temp_db_handle$db)
winvector_temp_db_handle <- NULL

}
